"""
从redis中读出企业信用代码，根据信用代码查询企业信息，拼接链接下载。
文件存储格式： 企业名称：
                年报.pdf
"""
import os
from pathlib import Path

from base.BaseCore import BaseCore
from datetime import datetime
baseCore = BaseCore()
import requests
import urllib3
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
log = baseCore.getLogger()
# 11数据库
cnx_ = baseCore.cnx_
cursor_ = baseCore.cursor_
r = baseCore.r

def search_att(social_code):
    sql = """select name, full_path from clb_sys_attachment where item_id=%s and type_id=1"""
    cursor_.execute(sql, social_code)
    results = cursor_.fetchall()
    return results



if __name__ == "__main__":
    while True:
        item = baseCore.redicPullData('NianBao:socialcode')

        # item = '9111000010001002XD|中国华能'
        social_code = item.split('|')[0]
        com_name = item.split('|')[1]
        results = search_att(social_code)

        if results:
            pass
        else:
            log.info(f'{item}---没有年报附件')
        for result in results:
            file_name = result[0]
            full_path = result[1]
            # 创建文件夹
            file_dir = f'D:\\kkwork\\企业数据\\年报附件\\{com_name}'
            Path(file_dir).mkdir(parents=True, exist_ok=True)
            file_name = file_name.replace(':', '：')
            pdf_path = os.path.join(file_dir, file_name)

            # 下载
            req = requests.get(full_path)
            if req.status_code == 200:
                with open(pdf_path, 'wb') as f:
                    f.write(req.content)
                log.info(f'{file_name}下载完成')
            else:
                log.info(f'{item}下载失败')
            # break
        # break

    pass
