import time
from datetime import datetime
from datetime import timedelta
from decimal import Decimal

import pymongo
import requests
from retry import retry
from apscheduler.schedulers.blocking import BlockingScheduler
import BaseCore

baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
db_storage = pymongo.MongoClient('mongodb://114.115.221.202:27017', username='admin', password='ZZsn@9988').RESCenter[
    'REITsTxnStat']
headers = {
    'Accept': 'application/json, text/javascript, */*; q=0.01',
    'Accept-Encoding': 'gzip, deflate',
    'Accept-Language': 'zh-CN,zh-TW;q=0.9,zh;q=0.8',
    'Cache-Control': 'no-cache',
    'Connection': 'keep-alive',
    'Content-Type': 'application/json',
    'Host': 'www.szse.cn',
    'Pragma': 'no-cache',
    'Referer': 'http://www.szse.cn/market/fund/dealSurvey/daily/index.html',
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36 Edg/119.0.0.0',
    'X-Request-Type': 'ajax',
    'X-Requested-With': 'XMLHttpRequest'
}


@retry(tries=5, delay=10)
def getJson(url):
    req = requests.get(url, headers=headers)
    req.encoding = req.apparent_encoding
    return req.json()[0]['data']

@retry(tries=5, delay=10)
def getJsonB(date):
    # headers = {
    #     'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36 Edg/120.0.0.0',
    # }
    url = f'http://www.szse.cn/api/report/ShowReport/data?SHOWTYPE=JSON&CATALOGID=1803_sczm&TABKEY=tab1&txtQueryDate={date}'
    req = requests.get(url, headers=headers)
    req.encoding = req.apparent_encoding
    datas = req.json()[0]['data']
    for data in datas:
        if '基础设施基金' in data['lbmc']:
            try:
                amount = db_storage.find_one({'exchange': '深圳证券交易所', 'strDate': date})['amount']
            except:
                log.error(f'{date}===无成交金额')
                break
            number = int(data['zqsl'])
            totalValue = float(Decimal(data['sjzz']) * Decimal('10000'))
            negoValue = float(Decimal(data['ltsz']) * Decimal('10000'))
            return number,totalValue,negoValue

def doJob():
    # start_date = datetime(2021, 6, 21)
    start_date = datetime.today() - timedelta(days=5)
    end_date = datetime.today() - timedelta(days=1)
    date_range = [start_date + timedelta(days=x) for x in range((end_date - start_date).days + 1)]
    for date in date_range:
        date_ = date.strftime('%Y-%m-%d')
        is_insert = db_storage.find_one({'strDate': str(date)[:10], 'exchange': '深圳证券交易所'})
        if is_insert:
            log.info(f'{date_}===已采集')
            time.sleep(3)
            continue
        url = f'http://www.szse.cn/api/report/ShowReport/data?SHOWTYPE=JSON&CATALOGID=scsj_jjrdgk&TABKEY=tab1&txtQueryDate={date_}&tjzqlb=D'
        data_json = getJson(url)
        for data in data_json:
            if '基础设施基金' in data['lbmc']:
                volume = data['cjl'].replace(',', '')
                amount = data['cjje'].replace(',', '')
                number,totalValue,negoValue = getJsonB(date_)
                toRate = float(Decimal(f'{amount}') / Decimal(f'{totalValue}') * Decimal('100'))
                dic_info = {
                    'number': number,  # 挂牌数
                    'volume': float(volume),  # 成交量
                    'amount': float(amount),  # 成交金额
                    'totalValue': totalValue,  # 市价总额
                    'negoValue': negoValue,  # 流通市值
                    'toRate': toRate,  # 换手率
                    'date': date,
                    'strDate': str(date)[:10],
                    'country': '中国',
                    'exchange': '深圳证券交易所',
                    'currency': 'CNY',  # 币种
                }
                try:
                    db_storage.insert_one(dic_info)
                    log.info(f'{date_}===数据采集成功')
                except:
                    log.error(f'{date_}===数据入库失败')
        time.sleep(3)


def task():
    # 实例化一个调度器
    scheduler = BlockingScheduler()
    # 每天执行一次
    scheduler.add_job(doJob, 'cron', hour='8', minute=0, max_instances=2 )
    try:
        scheduler.start()
    except Exception as e:
        log.error('定时采集异常', e)
        pass

if __name__ == '__main__':
    task()
    # number,totalValue,negoValue = getJsonB('2023-12-27')
    # print(number,totalValue,negoValue)
    baseCore.close()
