# -*- coding: utf-8 -*-
import datetime

import xlrd
from selenium.webdriver.support.wait import WebDriverWait
from tqdm import tqdm
import pymongo
import pymysql
import time
import requests
from pyquery import PyQuery as pq
from selenium import webdriver
import json
from requests.packages import urllib3
urllib3.disable_warnings()
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions as EC
import re
from BaseCore import BaseCore
import configparser
import redis

class Shizhi(object):
    def __init__(self):
        self.config = configparser.ConfigParser()
        # 读取配置文件
        self.config.read('config.ini')
        baseCore=BaseCore()
        self.logger=baseCore.getLogger()
        self.r = redis.Redis(host=self.config.get('redis', 'host'),
                             port=self.config.get('redis', 'port'),
                             password=self.config.get('redis', 'pass'), db=6)
        self.driver=self.get_webdriver()

    def get_webdriver(self):
        chrome_options = webdriver.ChromeOptions()
        chrome_options.add_argument('--disable-gpu')
        chrome_options.add_argument('--ignore-certificate-errors')
        chrome_options.add_experimental_option('excludeSwitches', ['enable-automation'])
        chrome_options.add_argument("--disable-blink-features=AutomationControlled")
        chrome_options.add_argument("--start-maximized")
        # chrome_options.add_argument('--headless')
        chrome_options.binary_location = self.config.get('selenium', 'binary_location')
        executable_path =self.config.get('selenium', 'chrome_driver')
        driver = webdriver.Chrome(options=chrome_options, executable_path=executable_path)
        return driver

    def conn11(self):
        conn = pymysql.Connect(host='114.116.44.11', port=3306, user='caiji', passwd='f7s0&7qqtK', db='clb_project',
                               charset='utf8')
        cursor = conn.cursor()
        return conn,cursor

    def getmarketCap(self):
        conn,cursor=self.conn11()
        try:
            sql1 = """select social_credit_code,securities_code,securities_short_name from sys_base_enterprise_ipo where category in ('4','5','6')  """  # and stock_code = "SYNH"
            cursor.execute(sql1)
            result_data = cursor.fetchall()
        except Exception as e:
            self.logger.info("数据查询异常！")
            return
        for data in result_data:
            try:
                data_list = list(data)
                print(data_list)
                social_credit_code = data_list[0]
                stock = data_list[1]
                securities_short_name = data_list[2] if data_list[2] is not None else ""
                # content_sql = ''
                stock2=str(stock)
                if stock2.upper().endswith("HK") and stock2.upper().startswith("0") :
                    stock2=stock2[1:]
                    # https://finance.yahoo.com/quote/032830.KS?p=032830.KS
                url = f'https://finance.yahoo.com/quote/{stock2}?p={stock2}'
                try:
                    self.logger.info(f'正在采集：{url}')
                    self.driver.get(url)
                    # 等待页面加载完成
                    wait = WebDriverWait(self.driver, 300)
                    wait.until(EC.presence_of_element_located((By.TAG_NAME, "body")))
                    time.sleep(5)
                    doc_resp = pq(self.driver.page_source)
                    unit=doc_resp('div[id="quote-header-info"]>div:nth-child(2)>div:nth-child(1)>div:nth-child(2)>span')
                    currency = unit.text().split("Currency in ")[1]
                    market_cap=doc_resp('td[data-test="MARKET_CAP-value"]')
                    marketcap=market_cap.text()
                    if marketcap and marketcap!='N/A':
                        # 获取当前时间
                        current_time = datetime.datetime.now()
                        currentdate = current_time.strftime("%Y-%m-%d")
                        print(f'信用代码：{social_credit_code} 股票代码：{stock}  币种：{currency}  市值：{marketcap} 日期：{currentdate}')
                        # market_url = f'http://192.168.1.39:8088/sync/marketValue'
                        market_url = f'http://114.115.236.206:8088/sync/marketValue'
                        param= {
                            "socialCreditCode": social_credit_code,
                            "stockCode": stock,
                            "marketValue": marketcap,
                            "originalUnit": currency,
                            "valueTime": currentdate
                        }
                        try:
                            resp = requests.post(market_url,json=param)
                            # 检查响应状态码
                            if resp.status_code == 200:
                                print("请求成功")
                                # 打印响应内容
                                print(resp.content)
                            else:
                                print("请求失败")
                        except:
                            with open('雅虎财经-财务数据_发送错误ID.txt', 'a', encoding='utf8')as f:
                                f.write(stock + '\n')

                except Exception as e:
                    self.driver.close()
                    self.driver.quit()
                    self.driver=self.get_webdriver()
                    print(e)
            except Exception as e:
                print(e)
                self.driver.close()
                self.driver.quit()
                self.driver=self.get_webdriver()

if __name__ == '__main__':
         shizhi=Shizhi()
         shizhi.getmarketCap()