import datetime
import os
import re
import time
import requests
from bs4 import BeautifulSoup
from pyquery import PyQuery as pq

from ClassTool import ClassTool
baseTool = ClassTool()

from BaseCore import BaseCore
baseCore = BaseCore()
log = baseCore.getLogger()

# 河南
def he_nan():
    num = 0
    count = 0
    pathType = 'policy/henan/'
    start_time = time.time()
    for page in range(0, 7):
        if page == 0:
            url = 'http://gzw.henan.gov.cn/xxgk/fdzdgknr/zcfg/index.html'
        else:
            url = f'http://gzw.henan.gov.cn/xxgk/fdzdgknr/zcfg/index_{page}.html'
        try:
            resp_text = requests.get(url=url, headers=headers, verify=False)
            doc_resp = pq(resp_text.content)
            doc_items = doc_resp('.mt15.list-box li').items()
            for doc_item in doc_items:
                title = doc_item('a').text().strip()
                href = doc_item('a').attr('href')
                is_href = baseTool.db_storage.find_one({'网址': href})
                if is_href:
                    num += 1
                    continue
                href_res = requests.get(url=href, headers=headers, verify=False)
                href_res.encoding = href_res.apparent_encoding
                href_text = href_res.text
                soup = BeautifulSoup(href_text, 'html.parser')
                origin = soup.select('#source')[0].text
                publishDate = soup.select('#pubDate')[0].text
                contentWithTag = str(soup.select('#content')[0])
                # contentWithTag =doc('div[class="information-zt-show"]')
                # soup=BeautifulSoup(str(contentWithTag), 'html.parser')
                soup = baseTool.paserUrl(str(contentWithTag), href)
                fu_jian_soup = soup.find_all('a')
                id_list = []
                for file in fu_jian_soup:
                    try:
                        file_href = file['href']
                    except Exception as e:
                        continue
                    if '.pdf' in file_href or '.docx' in file_href or '.doc' in file_href or 'xlsx' in file_href or '.zip' in file_href \
                            or '.rar' in file_href or '.ppt' in file_href or '.PDF' in file_href or '.DOC' in file_href \
                            or '.XLS' in file_href or '.ZIP' in file_href or '.RAR' in file_href:
                        file_name = file.text.strip()
                        category = os.path.splitext(file_href)[1]
                        if category not in file_name:
                            file_name = file_name + category
                        retData = baseCore.uptoOBS(file_href, '1690', file_name)
                        if retData['state']:
                            pass
                        else:
                            continue
                        att_id, full_path = baseCore.tableUpdate(retData, '河南省国资委', file_name, num, publishDate)
                        id_list.append(att_id)
                        # todo:将返回的地址更新到soup
                        file['href'] = 'http:zzsn.luyuen.com/' + str(full_path)

                contentWithTag = str(soup.prettify())
                content = soup.text
                if content == '' or content == None:
                    log.info(f'-----{href}----{title}----内容为空-----')
                    continue
                pattern = r'(豫国.{1,}?号)|(国.{1,}?号)'
                match_list = re.findall(pattern, content)
                if len(match_list) > 0:
                    issuedNumber = match_list[0][0]
                else:
                    issuedNumber = ''
                time_now = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())
                # todo:传kafka字段
                dic_news = {
                    'attachmentIds': id_list,
                    'author': '',
                    'content': str(content),
                    'contentWithTag': str(contentWithTag),
                    'createDate': time_now,
                    'deleteFlag': 0,
                    'id': '',
                    'labels': [{'relationId': "1690", 'relationName': "河南省国资委", 'labelMark': "policy"}],
                    'origin': origin,
                    'organ': '',
                    'topicClassification': '',
                    'issuedNumber': issuedNumber,
                    'publishDate': publishDate,
                    'writtenDate': None,
                    'sid': '1697458829758697473',
                    'sourceAddress': href,
                    'summary': '',
                    'title': title
                }
                # print(dic_news)
                flag = baseTool.sendKafka(dic_news)
                if flag:
                    baseTool.save_data(dic_news)
                    num += 1
                    count += 1
                href_res.close()
            resp_text.close()
        except:
            pass
    end_time = time.time()
    log.info(f'共抓取{count}条数据,共耗时{end_time - start_time}')

if __name__ == "__main__":
    he_nan()