import os
from flask import Flask, request, send_file, render_template
import json
import pymysql
'''
手动捕获请求的接口数据，实现解析
使用fiddler将链接对应的页面数据信息发送到后台，后台对数据进行解析

'''
def connMysql():
    # 创建MySQL连接
    conx = pymysql.connect(host='114.115.159.144',
                           user='caiji',
                           password='zzsn9988',
                           database='caiji')
    # 创建一个游标对象
    cursorM = conx.cursor()
    return conx,cursorM

def closeSql(conx,cursorM):
    # 关闭游标和连接
    cursorM.close()
    conx.close()

#将列表数据插入到表中 baidu_search_result
def itemInsertToTable(item):
    conx,cursorM=connMysql()
    zKeyNo=item['zKeyNo']
    yKeyNo=item['yKeyNo']
    try:
        select_sql=f'select * from qccholdmsg where yKeyNo="{yKeyNo}" and zKeyNo="{zKeyNo}" '
        cursorM.execute(select_sql)
        existing_record = cursorM.fetchone()
    except Exception as e:
        existing_record=''
    if existing_record:
        print(f'数据已存在！{zKeyNo}')
        return

    insert_param=(item['yKeyNo'],item['yCompanyName'],item['nameCount'],item['zKeyNo'],item['zName'],
          item['registCapi'],item['province'],item['industry'],item['shortStatus'],item['percentTotal'],item['startDateStr'],
          item['h5Url'],item['district'],item['industryDesc'],item['area'],item['industryItem'])
    insert_sql ="INSERT into qccholdmsg (yKeyNo,yCompanyName,nameCount,zKeyNo,zName,registCapi,province," \
         "industry,shortStatus,percentTotal,startDateStr,h5Url,district,industryDesc,area,industryItem) VALUES (%s, %s,%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)"
    cursorM.execute(insert_sql,insert_param)
    # 定义插入数据的SQL语句
    # 执行插入操作
    conx.commit()
    print('数据插入成功！')
    closeSql(conx,cursorM)


app = Flask(__name__)

@app.route('/')
def index():
    return 'Welcome to the website!'

@app.route('/get_hold', methods=['POST'])
def get_news():
    data=request.form

@app.route('/e1', methods=['POST'])
def e1():
    data = request.get_json()
    html = data.get('html')
    print(html)
    # 处理请求参数...

@app.route('/e2', methods=['POST'])
def e2():
    html = request.form.get('html')
    # print(html)
    print('获取fiddler抓取的数据')
    msg=json.loads(html)
    # 处理请求参数...
    yKeyNo=msg['Result']['KeyNo']
    yCompanyName=msg['Result']['CompanyName']
    NameCount=msg['Result']['NameCount']
    Names=msg['Result']['Names']
    for zzname in Names:
        item={}
        zKeyNo= zzname['KeyNo']
        zName= zzname['Name']
        registCapi= zzname['RegistCapi']
        imageUrl= zzname['ImageUrl']
        province= zzname['Province']
        industry= zzname['Industry']
        shortStatus= zzname['ShortStatus']
        percentTotal= zzname['PercentTotal']
        startDateStr= zzname['StartDateStr']
        h5Url= zzname['H5Url']
        district= zzname['District']
        industryDesc= zzname['IndustryDesc']
        # area= str(zzname['Area'])
        # industryItem= str(zzname['IndustryItem'])
        area=''
        industryItem=''
        item={
            'yKeyNo':yKeyNo,
            'yCompanyName':yCompanyName,
            'nameCount':NameCount,
            'zKeyNo':zKeyNo,
            'zName':zName,
            'registCapi':registCapi,
            'imageUrl':imageUrl,
            'province':province,
            'industry':industry,
            'shortStatus':shortStatus,
            'percentTotal':percentTotal,
            'startDateStr':startDateStr,
            'h5Url':h5Url,
            'district':district,
            'industryDesc':industryDesc,
            'area':area,
            'industryItem':industryItem,
        }
        try:
            print('对数据进行解析入库')
            itemInsertToTable(item)
        except Exception as e:
            print(e)
    return ""

def installToMysql():
    pass



if __name__ == '__main__':
    app.run(port=8000)


