"""
雪球网财务数据 根据接口
"""
import json
import time

import redis
import requests
from bs4 import BeautifulSoup
import datetime
from selenium import webdriver

from BaseCore import BaseCore
baseCore = BaseCore()
log = baseCore.getLogger()

def getFormatedate(timestamp):
    date = datetime.datetime.fromtimestamp(timestamp)
    formatted_date = date.strftime('%Y-%m-%d')
    return formatted_date

def check_code(com_code):
    r = redis.Redis(host="114.115.236.206",port=6379,password='clbzzsn',db=3)
    res = r.exists('com_xqcwsj_code::'+com_code)
    if res:
        return False
    else:
        return True

def check_date(com_code,info_date):
    r = redis.Redis(host="114.115.236.206", port=6379, password='clbzzsn', db=3)
    res = r.sismember('com_xqcwsj_code::'+com_code, info_date)  # 注意是 保存set的方式
    if res:
        return True
    else:
        return False

# 将采集后的股票代码对应的报告期保存进redis
def add_date(com_code,report_date):
    r = redis.Redis(host="114.115.236.206", port=6379, password='clbzzsn',db=3)

    res = r.sadd('com_xqcwsj_code::'+com_code,report_date)

def getrequests(url):
    req = requests.get(url=url, headers=headers)
    data = req.json()
    a_infoData = data['data']['list']
    return a_infoData

def getdriver(url_name):
    # 使用模拟浏览器打开
    browser.get(url_name)
    time.sleep(3)
    page_source = browser.page_source
    soup = BeautifulSoup(page_source, 'html.parser')
    return soup

def getdetail(reportInfodata,name_map,listinfo,url_name):
    # # 报告期
    # report_date = reportInfodata['report_date']
    # report_date = getFormatedate(int(report_date / 1000))
    #模拟浏览器请求
    soup = getdriver(url_name)
    time.sleep(2)
    # 利润表
    table = soup.find('div', class_='tab-table-responsive')
    list_tr = table.find_all('tr')
    for tr in list_tr[1:]:
        info_name = tr.find('td', colspan='2').text
        # 营业总收入
        try:
            info_enname = name_map[info_name]
            info_data = reportInfodata[info_enname][0]
            if info_data is None:
                info_data = '--'
        except:
            info_enname = '--'
            info_data = '--'
        dic_info = {
            "name": info_name,
            'enName': info_enname,
            "value": info_data
        }
        listinfo.append(dic_info)
    return listinfo

def getinfo(com_code,social_code):
    dic_info = {}
    for nnn in range(0, 3):
        try:
            ynFirst = check_code(com_code)
            break
        except:
            time.sleep(1)

          #'https://stock.xueqiu.com/v5/stock/finance/cn/balance.json?symbol=NQ873286&type=all&is_detail=true&count=5&timestamp=1694508688637'
    url_lrb = f'https://stock.xueqiu.com/v5/stock/finance/cn/income.json?symbol={com_code}&type=all&is_detail=true&count=5&timestamp=1694414063178'

    url_zcfzb = f'https://stock.xueqiu.com/v5/stock/finance/cn/balance.json?symbol={com_code}&type=all&is_detail=true&count=5&timestamp=1694508688637'

    url_xjllb = f'https://stock.xueqiu.com/v5/stock/finance/cn/cash_flow.json?symbol={com_code}&type=all&is_detail=true&count=5&timestamp=1694512695956'

    lrb_name = f'https://xueqiu.com/snowman/S/{com_code}/detail#/GSLRB'
    zcfzb_name = f'https://xueqiu.com/snowman/S/{com_code}/detail#/ZCFZB'
    xjllb_name = f'https://xueqiu.com/snowman/S/{com_code}/detail#/XJLLB'

    a_infoData = getrequests(url_lrb)
    b_infoData = getrequests(url_zcfzb)
    c_infoData = getrequests(url_xjllb)
    #对报告期做循环
    for i in range(0,5):
        listLrb = []
        listZcfzb = []
        listXjllb = []
        reportLrbdata = a_infoData[i]
        report_date = a_infoData[i]['report_date']
        #时间戳转化为日期
        report_date = getFormatedate(int(report_date / 1000))
        # 检查报告期是否已经存在
        for nnn in range(0, 3):
            try:
                panduan = check_date(com_code, report_date)
                if panduan:
                    return dic_info
                else:
                    pass
                break
            except:
                time.sleep(1)
        log.info(f'======正在采集：{com_code}---{report_date}=======')
        #利润表
        list_Lrb = getdetail(reportLrbdata,lrb_name_map,listLrb,lrb_name)
        log.info(f'利润表数据：{len(list_Lrb)}个')
        # print(list_Lrb)
        #资产负债表
        reportZcfzbdata = b_infoData[i]
        list_Zcfzb = getdetail(reportZcfzbdata,zcfzb_name_map,listZcfzb,zcfzb_name)
        #现金流量表
        reportXjllbdata = c_infoData[i]
        list_Xjllb = getdetail(reportXjllbdata,xjllb_name_map,listXjllb,xjllb_name)


        dic_info = {
            "socialCreditCode": social_code,
            "securitiesCode": com_code[2:],
            "date": report_date,
            "debt": list_Zcfzb,
            "profit": list_Lrb,
            "cash": list_Xjllb,
            "ynFirst": ynFirst,
        }
        # print(dic_info)
        #一个报告期结束
        log.info(f'----{com_code}--{report_date}----结束')
        if dic_info:
            # 调凯歌接口存储数据
            data = json.dumps(dic_info)
            # print(data)
            url_baocun = 'http://114.115.236.206:8088/sync/finance/df'
            for nnn in range(0, 3):
                try:
                    res_baocun = requests.post(url_baocun, data=data)
                    break
                except:
                    time.sleep(1)
            print(res_baocun.text)
            log.info('------------数据发送接口完毕------------')
            for nnn in range(0, 3):
                try:
                    add_date(com_code, report_date)
                    break
                except:
                    time.sleep(1)
        else:
            log.error(f'---{com_code}--{report_date}--')
        return dic_info

if __name__ == '__main__':
    info_date_list = []
    try:
        chromedriver = "D:/chrome/chromedriver.exe"
        browser = webdriver.Chrome(chromedriver)
    except Exception as e:
        print(e)
    headers = {
        'authority': 'stock.xueqiu.com',
        'method': 'GET',
        'path': '/v5/stock/finance/cn/income.json?symbol=NQ873286&type=all&is_detail=true&count=5&timestamp=1694414063178',
        'scheme': 'https',
        'Accept': 'application/json, text/plain, */*',
        'Accept-Encoding': 'gzip, deflate, br',
        'Accept-Language': 'zh-CN,zh;q=0.9',
        'Cache-Control': 'no-cache',
        'Cookie': 'device_id=84ced64554d8060750b1528dc22a3696; s=bt110kz0n8; cookiesu=661693188384462; u=661693188384462; Hm_lvt_1db88642e346389874251b5a1eded6e3=1693188388; xq_a_token=29bdb37dee2432c294425cc9e8f45710a62643a5; xqat=29bdb37dee2432c294425cc9e8f45710a62643a5; xq_r_token=3a35db27fcf5471898becda7aa5dab6afeafe471; xq_id_token=eyJ0eXAiOiJKV1QiLCJhbGciOiJSUzI1NiJ9.eyJ1aWQiOi0xLCJpc3MiOiJ1YyIsImV4cCI6MTY5NjgxMTc5NCwiY3RtIjoxNjk0NDEzNTQ2ODU4LCJjaWQiOiJkOWQwbjRBWnVwIn0.Xxu329nQq4bMtwKFJWlScnUUSWrky4T5SWkMum46c2G8la2z4g0d4nyvsO08WP-7moMffId6P3bGWuELULkbv6EHvIZgqge9-fAD4-hmLOjeRh96NsoGfyTAQK7tbnt9LhKz1fDg6SUi8loMqYgM7l-4g-ZM4B6zrZ5hKWdQJFLy0-V8Wzx7HTFYZSX3FNSsbgGqHlW4vykIpsRaNeOOX1M6LYdt6BhbAi1Iv4TflB08LIdu6F1n4dTRbmPq1KCndb2LsLR2HrJZmqmHJB9WMzwlVcIGdz778_CutNrwuWgJbWtb-s3dSESzO0WWw1uIIGZUvRl1D0KSl0P_GQLw9w; Hm_lpvt_1db88642e346389874251b5a1eded6e3=1694414056',
        'Origin': 'https://xueqiu.com',
        'Pragma': 'no-cache',
        'Referer': 'https://xueqiu.com/snowman/S/NQ873286/detail',
        'Sec-Ch-Ua': '"Not/A)Brand";v="99", "Google Chrome";v="115", "Chromium";v="115"',
        'Sec-Ch-Ua-Mobile': '?0',
        'Sec-Ch-Ua-Platform': '"Windows"',
        'Sec-Fetch-Dest': 'empty',
        'Sec-Fetch-Mode': 'cors',
        'Sec-Fetch-Site': 'same-site',
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/115.0.0.0 Safari/537.36'
    }
    #中英文名称映射
    lrb_name_map = {
        '营业总收入':'total_revenue',
        '其中：营业收入':'revenue',
        '营业总成本':'operating_costs',
        '其中：营业成本':'operating_cost',
        '营业税金及附加':'operating_taxes_and_surcharge',
        '销售费用':'sales_fee',
        '管理费用':'manage_fee',
        '研发费用':'rad_cost',
        '财务费用':'financing_expenses',
        '其中：利息费用':'finance_cost_interest_fee',
        '利息收入':'finance_cost_interest_income',
        '资产减值损失':'asset_impairment_loss',
        '信用减值损失':'credit_impairment_loss',
        '加：公允价值变动收益':'',
        '投资收益':'invest_income',
        '其中：对联营企业和合营企业的投资收益':'',
        '资产处置收益':'asset_disposal_income',
        '其他收益':'other_income',
        '营业利润':'op',
        '加：营业外收入':'non_operating_income',
        '其中：非流动资产处置利得':'',
        '减：营业外支出':'non_operating_payout',
        '其中：非流动资产处置损失':'',
        '利润总额':'profit_total_amt',
        '减：所得税费用':'income_tax_expenses',
        '净利润差额(合计平衡项目)':'',
        '净利润':'net_profit',
        '（一）持续经营净利润':'continous_operating_np',
        '归属于母公司股东的净利润':'net_profit_atsopc',
        '少数股东损益':'minority_gal',
        '扣除非经常性损益后的净利润':'net_profit_after_nrgal_atsolc',
        '基本每股收益':'basic_eps',
        '稀释每股收益':'dlt_earnings_per_share',
        '其他综合收益':'othr_compre_income',
        '归属母公司所有者的其他综合收益':'',
        '综合收益总额':'total_compre_income',
        '归属于母公司股东的综合收益总额':'net_profit_atsopc',
        '归属于少数股东的综合收益总额':'total_compre_income_atms'

    }
    zcfzb_name_map = {
        '货币资金':'currency_funds',
        '交易性金融资产':'',
        '应收票据及应收账款':'ar_and_br',
        '其中：应收票据':'bills_receivable',
        '应收账款':'account_receivable',
        '预付款项':'pre_payment',
        '应收利息':'',
        '应收股利':'',
        '其他应收款':'othr_receivables',
        '存货':'inventory',
        '合同资产':'',
        '划分为持有待售的资产':'',
        '一年内到期的非流动资产':'nca_due_within_one_year',
        '其他流动资产':'intangible_assets',
        '流动资产合计':'total_current_assets',
        '可供出售金融资产':'',
        '持有至到期投资':'',
        '长期应收款':'',
        '长期股权投资':'',
        '其他权益工具投资':'',
        '其他非流动金融资产':'',
        '投资性房地产':'',
        '固定资产合计':'fixed_asset_sum',
        '其中：固定资产':'fixed_asset',
        '固定资产清理':'',
        '在建工程合计':'construction_in_process_sum',
        '其中：在建工程':'construction_in_process',
        '工程物资':'',
        '生产性生物资产':'',
        '油气资产':'',
        '无形资产':'intangible_assets',
        '开发支出':'dev_expenditure',
        '商誉':'',
        '长期待摊费用':'lt_deferred_expense',
        '递延所得税资产':'dt_assets',
        '其他非流动资产':'othr_noncurrent_assets',
        '非流动资产合计':'total_noncurrent_assets',
        '资产合计':'total_assets',
        '短期借款':'st_loan',
        '交易性金融负债':'',
        '衍生金融负债':'',
        '应付票据及应付账款':'accounts_payable',
        '应付票据':'',
        '应付账款':'',
        '预收款项':'',
        '合同负债':'contract_liabilities',
        '应付职工薪酬':'payroll_payable',
        '应交税费':'tax_payable',
        '应付利息':'',
        '应付股利':'',
        '其他应付款':'othr_payables',
        '划分为持有待售的负债':'',
        '一年内到期的非流动负债':'noncurrent_liab_due_in1y',
        '其他流动负债':'othr_current_liab',
        '流动负债合计':'total_current_liab',
        '长期借款':'lt_loan',
        '应付债券':'',
        '长期应付款合计':'lt_payable_sum',
        '长期应付款':'lt_payable',
        '专项应付款':'',
        '预计负债':'',
        '递延所得税负债':'dt_liab',
        '递延收益-非流动负债':'',
        '其他非流动负债':'',
        '非流动负债合计':'total_noncurrent_liab',
        '负债合计':'total_liab',
        '实收资本(或股本)':'shares',
        '其他权益工具':'',
        '永续债':'',
        '资本公积':'capital_reserve',
        '减：库存股':'',
        '其他综合收益':'',
        '专项储备':'special_reserve',
        '盈余公积':'earned_surplus',
        '未分配利润':'undstrbtd_profit',
        '一般风险准备':'',
        '外币报表折算差额':'',
        '归属于母公司股东权益合计':'total_quity_atsopc',
        '少数股东权益':'minority_equity',
        '股东权益合计':'total_holders_equity',
        '负债和股东权益总计':'total_assets'
    }
    xjllb_name_map = {
        '销售商品、提供劳务收到的现金':'cash_received_of_sales_service',
        '收到的税费返还':'refund_of_tax_and_levies',
        '收到其他与经营活动有关的现金':'cash_received_of_othr_oa',
        '经营活动现金流入小计':'sub_total_of_ci_from_oa',
        '购买商品、接受劳务支付的现金':'goods_buy_and_service_cash_pay',
        '支付给职工以及为职工支付的现金':'cash_paid_to_employee_etc',
        '支付的各项税费':'payments_of_all_taxes',
        '支付其他与经营活动有关的现金':'othrcash_paid_relating_to_oa',
        '经营活动现金流出小计':'sub_total_of_cos_from_oa',
        '经营活动产生的现金流量净额':'ncf_from_oa',
        '收回投资收到的现金':'cash_received_of_dspsl_invest',
        '取得投资收益收到的现金':"othrcash_paid_relating_to_fa",
        '处置固定资产、无形资产和其他长期资产收回的现金净额':'net_cash_of_disposal_assets',
        '处置子公司及其他营业单位收到的现金净额':'',
        '收到其他与投资活动有关的现金':'',
        '投资活动现金流入小计':'sub_total_of_ci_from_ia',
        '购建固定资产、无形资产和其他长期资产支付的现金':'cash_paid_for_assets',
        '投资支付的现金':'invest_paid_cash',
        '取得子公司及其他营业单位支付的现金净额':'',
        '支付其他与投资活动有关的现金':'',
        '投资活动现金流出小计':'sub_total_of_cos_from_ia',
        '投资活动产生的现金流量净额':'ncf_from_ia',
        '筹资活动产生的现金流量':'',
        '吸收投资收到的现金':'cash_received_of_absorb_invest',
        '其中：子公司吸收少数股东投资收到的现金':'',
        '取得借款收到的现金':'cash_received_of_borrowing',
        '发行债券收到的现金':'',
        '收到其他与筹资活动有关的现金':'cash_received_of_othr_fa',
        '筹资活动现金流入小计':'sub_total_of_ci_from_fa',
        '偿还债务支付的现金':'cash_pay_for_debt',
        '分配股利、利润或偿付利息支付的现金':'cash_paid_of_distribution',
        '其中：子公司支付给少数股东的股利':'',
        '支付其他与筹资活动有关的现金':'othrcash_paid_relating_to_fa',
        '筹资活动现金流出小计':'sub_total_of_cos_from_fa',
        '筹资活动产生的现金流量净额':'ncf_from_fa',
        '汇率变动对现金及现金等价物的影响':'',
        '现金及现金等价物净增加额':'net_increase_in_cce',
        '加：期初现金及现金等价物余额':'final_balance_of_cce',
        '期末现金及现金等价物余额':'final_balance_of_cce'
    }
    table_type = ['income','balance']
    flag = 0
    while True:
        # com_code = baseCore.redicPullData('NQEnterprise:nq_finance')
        com_code = baseCore.redicPullData('NQEnterprise:nq_finance_test')
        if com_code is None:
            if flag==0:
                log.info('已没有数据----------等待')
                time.sleep(20)
                continue
            elif flag==1:
                log.info('=============调用对比指标接口======')
                time.sleep(5400)
                url_ = 'http://114.115.236.206:8088/sync/calculateIndex?type=1'
                for nnn in range(0, 3):
                    try:
                        res_ = requests.get(url_)
                        break
                    except:
                        time.sleep(1)
                print(res_.text)
                log.info('-----------数据触发对比指标接口完毕----------')
                flag = 0
                continue
        log.info(f'========正在采集{com_code}===========')
        data = baseCore.getInfomation(com_code)
        social_code = data[1]
        short_name = data[3]
        start = time.time()
        com_code = 'NQ' + com_code
        dic_info = getinfo(com_code,social_code)
        flag =1







