import re
import time

import numpy as np
import pandas as pd
import requests
import os
import json
from base import BaseCore

baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()

headers = {
    'Accept': 'application/json, text/javascript, */*; q=0.01',
    'Accept-Encoding': 'gzip, deflate',
    'Accept-Language': 'zh-CN,zh-TW;q=0.9,zh;q=0.8',
    'Cache-Control': 'no-cache',
    'Connection': 'keep-alive',
    'Content-Type': 'application/json;charset=utf-8',
    'Host': 'reits.szse.cn',
    'Pragma': 'no-cache',
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36 Edg/119.0.0.0',
    'X-Requested-With': 'XMLHttpRequest',
}


def getPageSize():
    ip = baseCore.get_proxy()
    url = 'http://reits.szse.cn/api/reits/projectrends/query?biztypsb=21&bizType=2&pageIndex=0&pageSize=10'
    req = requests.get(url, headers=headers, proxies=ip)
    req.encoding = req.apparent_encoding
    total = int(req.json()['totalSize'])
    if total % 10 == 0:
        pageSize = int(total / 10)
    else:
        pageSize = int(total / 10) + 1
    return pageSize


def getDataJson(page):
    ip = baseCore.get_proxy()
    url = f'http://reits.szse.cn/api/reits/projectrends/query?biztypsb=21&bizType=2&pageIndex={page}&pageSize=10'
    req = requests.get(url, headers=headers, proxies=ip)
    req.encoding = req.apparent_encoding
    data_json = req.json()['data']
    return data_json


def doJob():
    info_list = []
    pageSize = getPageSize()
    for page in range(pageSize):
        data_json = getDataJson(page)
        for data_ in data_json:
            cmpnm = data_['cmpnm']
            specialPlanName = data_['specialPlanName']
            issueTargetName = data_['issueTargetName']
            primitiveInterestsor = data_['primitiveInterestsor']
            acctfm = data_['acctfm']
            sprinst = data_['sprinst']
            lawfm = data_['lawfm']
            biztypsbName = data_['biztypsbName']
            prjst = data_['prjst']
            updtdt = data_['updtdt']
            acptdt = data_['acptdt']
            info_list.append([cmpnm,specialPlanName,issueTargetName,primitiveInterestsor,acctfm,sprinst,lawfm,biztypsbName,prjst,updtdt,acptdt])
    df = pd.DataFrame(np.array(info_list))
    df.columns = ['基金名称','专项计划名称','基础设施项目类型','原始权益人','基金管理人','专项计划管理人','托管人','申报类型','审核状态','更新日期','受理日期']
    df.to_excel('./市场板块/深圳交易所项目动态.xlsx',index=False)

if __name__ == '__main__':
    doJob()
    baseCore.close()
