import gc
from flask import Blueprint, request, current_app, make_response, send_file  # 导入蓝图
import datetime
import re
import os
import logging
import sys
import io
import tempfile
import openpyxl
import string
import json

from selenium.webdriver.common.proxy import Proxy, ProxyType
from selenium import webdriver
from selenium.webdriver.common.by import By

from util import UtilDate
from service.Service02 import Service02

Main = Blueprint('Main', __name__)  # 初始化一个蓝图，而不是Flask对象


# 接受请求，读取请求体中的JSON参数，根据参数进行抓取动作
# {"from":"1900-01-01","last":最近x天数, "orgs":["单位1全称","单位2全称","单位3全称",...]}
@Main.route('/Main/getData', methods=["POST"])
def getData():
    print("POST /Main/getData")
    paras = request.get_json(force=True)
    dateFrom = paras['from']
    lastDays = paras['last']
    orgs = paras['orgs']
    if dateFrom == "":
        if lastDays == "":
            lastDays = 0
        else:
            lastDays = -(int(lastDays) - 1)
        dateFrom = UtilDate.dateAdd("", "d", lastDays)

    service02 = Service02()
    return service02.getData(dateFrom, orgs) #"https://wenshu.court.gov.cn/website/wenshu/181029CR4M5A62CH/index.html"
