import pandas as pd
import urllib3
import BaseCore
from elasticsearch import Elasticsearch

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

es = Elasticsearch([{'host': '114.115.215.250', 'port': '9700'}], http_auth=('elastic', 'zzsn9988'), timeout=600)

baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
r = baseCore.r

cnx_11 = baseCore.cnx_
cursor_11 = baseCore.cursor_

def getList():
    df = pd.read_excel('./中国500强榜单年报.xlsx', sheet_name='Sheet1')
    for i in range(len(df)):
        social_code = df['企业信用代码'][i]
        year = df['年报年份'][i]
        sql = 'Select id,item_id,year from clb_sys_attachment where type_id = 1 and item_id = %s and year = %s'
        cursor_11.execute(sql,(social_code, year))
        datas = cursor_11.fetchall()
        if datas:
            gg_social_list = [str(item[1]) + "|" + str(item[0]) + "|" + str(item[2]) for item in datas]
            print('=======')
            for item in gg_social_list:
                r.rpush("NianBao:info", item)
        else:
            log.info(f'{social_code}|{year}======不存在')

if __name__ == "__main__":
    getList()
