"""
从es中拿到所有的标题
"""
import redis
from elasticsearch import Elasticsearch
from base import BaseCore

baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()

class EsMethod(object):

    def __init__(self):
        # 创建Elasticsearch对象，并提供账号信息
        self.es = Elasticsearch(['http://114.116.19.92:9700'], http_auth=('elastic', 'zzsn9988'), timeout=300)
        self.index_name = 'subjectdatabase'

    def queryatt(self,index_name,pnum):
       body = {
           "query": {
               "match": {
                   "subjectId": "1534423014825668610"
               }
           },
           "sort": [
               {
                   "publishDate": {
                       "order": "desc"
                   }
               }
           ],
           "track_total_hits": True,
           "size": 200,
           "from": pnum
       }

       filter_path = ['hits.hits._id',
                      'hits.total.value',
                      'hits.hits._source.title',
                      'hits.hits._source.origin',
                      'hits.hits._source.publishDate',
                      'hits.hits._source.sourceAddress',
                      ]  # 字段2
       result = self.es.search(index=index_name
                               , doc_type='_doc'
                               , filter_path=filter_path
                               , body=body)
       # log.info(result)
       return result



if __name__ == '__main__':
    es_method = EsMethod()
    # 连接Redis
    r = redis.Redis(host="114.115.236.206", port=6379, password='clbzzsn', db=6)
    for i in range(56):
        result = es_method.queryatt('subjectdatabase', i*200)
        total = result['hits']['total']['value']
        try:
            msglist = result['hits']['hits']
        except:
           log.info(f'error-----{result}')
           continue
        log.info(f'---第{i}页{len(msglist)}条数据----共{total}条数据----')

        for mms in msglist:
           id = mms['_id']
           title = mms['_source']['title']
           origin = mms['_source']['origin']
           pub_time = mms['_source']['publishDate']
           sourceAddress = mms['_source']['sourceAddress']
           try:
               log.info(f'{id}--{title}--{origin}-{sourceAddress}-')
               item = id + "|" + pub_time + "|" + title + "|" + origin + "|" + sourceAddress
               # r.lrem(f'XJPdatabase:id_2', 0, item)
               r.lpush(f'XJPdatabase:id', item)
           except:
               continue
