#!/usr/bin/env python
# coding=utf-8

import json
import time
import pymongo
from bs4 import BeautifulSoup
from kafka import KafkaProducer
from requests.packages import urllib3
from urllib.parse import urljoin

from BaseCore import BaseCore
baseCore = BaseCore()

urllib3.disable_warnings()
from selenium import webdriver
from selenium.webdriver.chrome.service import Service


log = baseCore.getLogger()


class ClassTool():
    def __init__(self):
        self.taskType = '政策法规'

        self.db_storage =pymongo.MongoClient('mongodb://114.115.221.202:27017', username='admin', password='ZZsn@9988').ZZSN[
            '国务院_国资委_copy1']

        self.driver_path = r'D:\cmd100\chromedriver.exe'
        self.chromr_bin = r'D:\Google\Chrome\Application\chrome.exe'

        self.headers = {
            'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36',
        }

    # 将html中的相对地址转换成绝对地址
    def paserUrl(self, html, listurl):
        # 获取所有的<a>标签和<img>标签
        if isinstance(html, str):
            html = BeautifulSoup(html, 'html.parser')

        links = html.find_all(['a', 'img'])
        # 遍历标签，将相对地址转换为绝对地址
        for link in links:
            if 'href' in link.attrs:
                link['href'] = urljoin(listurl, link['href'])
            elif 'src' in link.attrs:
                link['src'] = urljoin(listurl, link['src'])
        return html


    def getDriver(self):
        service = Service(self.driver_path)
        chrome_options = webdriver.ChromeOptions()
        # chrome_options.add_argument('--headless')
        chrome_options.add_argument('--disable-gpu')
        # chrome_options.add_argument('--no-sandbox')
        chrome_options.add_argument('log-level=3')
        chrome_options.add_argument('--disable-dev-shm-usage')
        chrome_options.add_experimental_option('excludeSwitches', ['enable-automation'])  # 屏蔽chrome自动化受控提示
        chrome_options.add_argument("--disable-blink-features=AutomationControlled")  # 禁用启用Blink运行时的功能去掉webdriver痕迹
        chrome_options.add_experimental_option('useAutomationExtension', False)
        chrome_options.add_argument('lang=zh-CN,zh,zh-TW,en-US,en')
        chrome_options.binary_location = self.chromr_bin
        chrome_options.add_argument(
            'user-agent=Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.116 Safari/537.36')
        # bro = webdriver.Chrome(chrome_options=chrome_options, service=service)
        bro = webdriver.Chrome(chrome_options=chrome_options, executable_path=self.driver_path)
        # with open('stealth.min.js') as f:
        #     js = f.read()
        #
        # bro.execute_cdp_cmd("Page.addScriptToEvaluateOnNewDocument", {
        #     "source": js
        # })
        return bro


    def save_data(self, dic_news):
        aaa_dic = {

            '附件id': dic_news['attachmentIds'],
            '网址': dic_news['sourceAddress'],
            'tid': dic_news['labels'][0]['relationId'],
            '来源': dic_news['labels'][0]['relationName'],
            '创建时间': dic_news['createDate'],
            '带标签内容': dic_news['contentWithTag'][:100],
            '发布时间': dic_news['publishDate']
        }
        self.db_storage.insert_one(aaa_dic)


    def sendKafka(self, dic_news):
        try:  # 114.116.116.241
            producer = KafkaProducer(bootstrap_servers=['114.115.159.144:9092'], max_request_size=1024 * 1024 * 20)
            kafka_result = producer.send("policy",
                                         json.dumps(dic_news, ensure_ascii=False).encode('utf8'))

            print(kafka_result.get(timeout=10))

            dic_result = {
                'success': 'ture',
                'message': '操作成功',
                'code': '200',
            }
            log.info(dic_result)
            # 传输成功,写入日志中
            return True

        except Exception as e:

            dic_result = {
                'success': 'false',
                'message': '操作失败',
                'code': '204',
                'e': e
            }
            log.error(dic_result)
            return False