import os
import re
import time

import numpy as np
import pandas as pd
import requests
from bs4 import BeautifulSoup
from selenium.webdriver.common.by import By

from base import BaseCore

baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()

headers = {
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36 Edg/119.0.0.0',
    'Content-Type': 'application/x-www-form-urlencoded',
    'Accept': 'application/json, text/javascript, */*; q=0.01',
}


def getSoup(url):
    ip = baseCore.get_proxy()
    req = requests.get(url, headers=headers, proxies=ip)
    req.encoding = req.apparent_encoding
    soup = BeautifulSoup(req.text, 'html.parser')
    return soup


def getFjContent(url):
    ip = baseCore.get_proxy()
    req = requests.get(url, headers=headers, proxies=ip)
    req.encoding = req.apparent_encoding
    return req.content


def getContentA(url, num, publishDate, title):
    fjhref_list = ''
    fjtitle_list = ''
    soup = getSoup(url)
    organ = soup.find('div', class_='sp_time').text.split('来源：')[1].split('字体')[0].lstrip().strip()
    contentWithTag = soup.find('div', attrs={'id': 'zoom'})
    try:
        scripts = contentWithTag.find_all('script')
        for script in scripts:
            script.decompose()
    except:
        pass
    try:
        styles = contentWithTag.find_all('style')
        for style in styles:
            style.decompose()
    except:
        pass
    try:
        num_ = 1
        img_list = contentWithTag.find_all('img')
        for img in img_list:
            fj_href = img.get('src')
            try:
                fj_href = 'http://www.jiangsu.gov.cn' + fj_href
                fjhref_list += fj_href + '\n'
                fj_title = img.get('title').lstrip().strip()
                fj_title = f'{num}-{publishDate}-{fj_title}'
                fjtitle_list += fj_title + '\n'
            except:
                if 'img/png' in fj_href:
                    fj_title = f'{num}-{publishDate}-{title}-{num_}.png'
                elif 'img/jpg' in fj_href:
                    fj_title = f'{num}-{publishDate}-{title}-{num_}.jpg'
                num_ += 1
            fjcontent = getFjContent(fj_href)
            file = f'./相关政策/江苏省人民政府/政策文件/{fj_title}'
            with open(file, 'wb') as f:
                f.write(fjcontent)
            log.info(f'{fj_title}===附件下载成功')
    except:
        pass

    content = contentWithTag.text
    return organ, content, fjtitle_list, fjhref_list


def getContentB(url, num, publishDate, title):
    fjhref_list = ''
    fjtitle_list = ''
    soup = getSoup(url)
    info = soup.find('table', class_='xxgk_table').text.replace(' ','')
    organ = info.split('发布机构：')[1].split('发文日期')[0].lstrip().strip()
    writtenDate = info.split('发文日期：')[1].split('标题：')[0].lstrip().strip()
    pub_hao = info.split('文号：')[1].split('内容概述：')[0].lstrip().strip()
    contentWithTag = soup.find('div', class_='article_content')
    try:
        scripts = contentWithTag.find_all('script')
        for script in scripts:
            script.decompose()
    except:
        pass
    try:
        styles = contentWithTag.find_all('style')
        for style in styles:
            style.decompose()
    except:
        pass
    # try:
    num_ = 1
    img_list = contentWithTag.find_all('img')
    for img in img_list:
        fj_href = img.get('src')
        try:
            fj_title = img.get('title').lstrip().strip()
            fj_title = f'{num}-{publishDate}-{fj_title}'
            fjtitle_list += fj_title + '\n'
            fj_href = 'http://www.jiangsu.gov.cn' + fj_href
            fjhref_list += fj_href + '\n'
            fjcontent = getFjContent(fj_href)
            file = f'./相关政策/江苏省人民政府/政策文件/{fj_title}'
            with open(file, 'wb') as f:
                f.write(fjcontent)
            log.info(f'{fj_title}===附件下载成功')
        except:
            if 'image/png' in fj_href:
                fj_title = f'{num}-{publishDate}-{title}-{num_}.png'
            elif 'image/jpg' in fj_href:
                fj_title = f'{num}-{publishDate}-{title}-{num_}.jpg'
            num_ += 1
            fjtitle_list += fj_title + '\n'
    content = contentWithTag.text.lstrip().strip()
    return organ, writtenDate, pub_hao, content, fjtitle_list, fjhref_list


def doJob():
    if not os.path.exists('./相关政策/江苏省人民政府/政策文件'):
        os.makedirs('./相关政策/江苏省人民政府/政策文件')
    pattern = r"\d{4}-\d{2}-\d{2}"
    url = 'http://www.jiangsu.gov.cn/jsearchfront/search.do?websiteid=320000000100000&searchid=12&pg=&p=1&tpl=38&serviceType=&cateid=27&q=REITs&pq=&oq=&eq=&pos=&sortType=0&begin=&end='
    driver = baseCore.buildDriver()
    driver.get(url)
    time.sleep(5)
    div_list = driver.find_elements(By.CLASS_NAME,'news-result')
    num = 1
    data_list = []
    for div in div_list:
        title = div.find_element(By.CLASS_NAME, 'jcse-news-title').find_element(By.TAG_NAME,'a').get_attribute('title').lstrip().strip()
        href = div.find_element(By.CLASS_NAME, 'jcse-news-title').find_element(By.TAG_NAME,'a').get_attribute('href')
        type = div.find_element(By.CLASS_NAME, 'biaoqian').text.lstrip().strip()
        summary = div.find_element(By.CLASS_NAME, 'jcse-news-abs-content').text.lstrip().strip()
        dateInfo = div.find_element(By.CLASS_NAME, 'jcse-news-date').text
        publishDate = re.findall(pattern, dateInfo)[0]
        origin = dateInfo.replace(publishDate, '').lstrip().strip()
        if type == '政务公开':
            organ, content, fjtitle_list, fjhref_list = getContentA(href, num, publishDate, title)
            writtenDate = ''
            pub_hao = ''
        else:
            organ, writtenDate, pub_hao, content, fjtitle_list, fjhref_list = getContentB(href, num, publishDate, title)
        data = [num, title, publishDate, origin, href, writtenDate, organ, pub_hao, summary, content, fjtitle_list,
                 fjhref_list]
        data_list.append(data)
        log.info(f'{title}===采集成功')
        num += 1
        time.sleep(5)
    driver.close()
    df = pd.DataFrame(np.array(data_list))
    df.columns = ['序号', '标题', '发布时间', '来源', '原文链接', '发文时间', '发文机构', '发文字号', '摘要', '正文', '附件名称', '附件连接']
    df.to_excel('./江苏省人民政府政策文件.xlsx', index=False)


if __name__ == '__main__':
    doJob()
    baseCore.close()
