import hashlib
import json
import os
import re
import time
import uuid

import pymongo
import requests
import pandas as pd
import numpy as np
from datetime import datetime, timedelta

from obs import ObsClient
from retry import retry

from base import BaseCore
from urllib.parse import unquote

obsClient = ObsClient(
    access_key_id='VEHN7D0TJ9316H8AHCAV',  # 你的华为云的ak码
    secret_access_key='heR353lvSWVPNU8pe2QxDtd8GDsO5L6PGH5eUoQY',  # 你的华为云的sk
    server='https://obs.cn-north-1.myhuaweicloud.com'  # 你的桶的地址
)
baseCore = BaseCore.BaseCore()

db_storage = pymongo.MongoClient('mongodb://114.115.221.202:27017', username='admin', password='ZZsn@9988').RESCenter[
    'REITsProjDynamics']

cursor_ = baseCore.cursor_
cnx_ = baseCore.cnx_
log = baseCore.getLogger()
headers = {
    'Accept': '*/*',
    'Accept-Encoding': 'gzip, deflate',
    'Accept-Language': 'zh-CN,zh-TW;q=0.9,zh;q=0.8',
    'Cache-Control': 'no-cache',
    'Connection': 'keep-alive',
    'Host': 'query.sse.com.cn',
    'Pragma': 'no-cache',
    'Referer': 'http://www.sse.com.cn/',
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36 Edg/119.0.0.0',
}


class obsOperate():
    def __init__(self, cursor_, cnx_, log):
        self.headers = {
            'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
            'Accept-Encoding': 'gzip, deflate',
            'Accept-Language': 'zh-CN,zh-TW;q=0.9,zh;q=0.8',
            'Cache-Control': 'no-cache',
            'Connection': 'keep-alive',
            'Host': 'static.sse.com.cn',
            'Pragma': 'no-cache',
            'Referer': 'http://www.sse.com.cn/',
            'Upgrade-Insecure-Requests': '1',
            'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36 Edg/119.0.0.0',
        }
        self.cursor_ = cursor_
        self.cnx_ = cnx_
        self.log = log

    def secrchATT(self, item_id, file_name, type_id, order_by):
        sel_sql = '''select id from clb_sys_attachment where item_id = %s and name = %s and type_id=%s and order_by=%s '''
        self.cursor_.execute(sel_sql, (item_id, file_name, type_id, order_by))
        selects = self.cursor_.fetchone()
        return selects

    # 插入到att表 返回附件id
    def tableUpdate(self, retData, com_name, file_name, num, pub_time):
        item_id = retData['item_id']
        type_id = retData['type_id']
        group_name = retData['group_name']
        path = retData['path']
        full_path = retData['full_path']
        category = retData['category']
        file_size = retData['file_size']
        status = retData['status']
        create_by = retData['create_by']
        page_size = retData['page_size']
        create_time = retData['create_time']
        order_by = num

        Upsql = '''insert into clb_sys_attachment(name,type_id,item_id,group_name,path,full_path,category,file_size,order_by,status,create_by,create_time,object_key,bucket_name,publish_time) values(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)'''

        values = (
            file_name, type_id, item_id, group_name, path, full_path, category, file_size, order_by,
            status, create_by,
            create_time, path, 'zzsn', pub_time)

        self.cursor_.execute(Upsql, values)  # 插入
        self.cnx_.commit()  # 提交
        self.log.info("更新完成:{}".format(Upsql))
        selects = self.secrchATT(item_id, file_name, type_id, order_by)
        id = selects[0]
        return id, full_path

    def getuuid(self):
        get_timestamp_uuid = uuid.uuid1()  # 根据 时间戳生成 uuid , 保证全球唯一
        return get_timestamp_uuid

    # 获取文件大小
    def convert_size(self, size_bytes):
        # 定义不同单位的转换值
        units = ['bytes', 'KB', 'MB', 'GB', 'TB']
        i = 0
        while size_bytes >= 1024 and i < len(units) - 1:
            size_bytes /= 1024
            i += 1
        return f"{size_bytes:.2f} {units[i]}"

    @retry(tries=5, delay=10)
    def getRes(self, file_href):
        response = requests.get(file_href, headers=self.headers)
        if response.status_code != 200:
            raise
        return response

    @retry(tries=5, delay=10)
    def sendOBS(self, file_name, response):
        result = obsClient.putContent('zzsn', 'PolicyDocument/' + file_name, content=response.content)
        return result

    def uptoOBS(self, file_href, item_id, file_name):

        category = os.path.splitext(file_href)[1]
        retData = {'state': False, 'type_id': 15, 'item_id': item_id, 'group_name': '', 'path': '',
                   'full_path': '',
                   'category': category, 'file_size': '', 'status': 1, 'create_by': 'LiuLiYuan',
                   'create_time': '', 'page_size': '', 'content': ''}
        try:
            response = self.getRes(file_href)
        except:
            self.log.error('文件获取失败')
            return retData

        file_size = int(response.headers.get('Content-Length'))
        file_name = str(self.getuuid()) + category
        try:
            result = self.sendOBS(file_name, response)
        except:
            self.log.error(f'obs上传失败')
            return retData
        try:
            time_now = time.strftime("%Y-%m-%d %H:%M:%S", time.localtime())
            retData['state'] = True
            retData['path'] = result['body']['objectUrl'].split('.com')[1]
            retData['full_path'] = unquote(result['body']['objectUrl'])
            retData['file_size'] = self.convert_size(file_size)
            retData['create_time'] = time_now
        except Exception as e:
            print(f'error:{e}')
            return retData
        return retData


def md5_encrypt(text):
    # 创建 MD5 对象
    md5 = hashlib.md5()

    # 更新 MD5 对象内容
    md5.update(text.encode('utf-8'))

    # 获取加密结果
    encrypted_text = md5.hexdigest()

    return encrypted_text

# 获取json数据
def getJson(url):
    # ip = baseCore.get_proxy()
    req = requests.get(url, headers=headers)
    req.encoding = req.apparent_encoding
    data_json = re.findall('\((.*)\)', req.text)[0]
    data_json = json.loads(data_json)
    return data_json


# 获取总页数
def getTotal():
    url = f'http://query.sse.com.cn/commonQuery.do?jsonCallBack=jsonpCallback51800&isPagination=true&bond_type=4&sqlId=COMMON_SSE_ZCZZQXMLB&pageHelp.pageSize=25&status=&begin=&end=&pageHelp.cacheSize=1&pageHelp.pageNo=1&pageHelp.beginPage=1&_={int(time.time())}'
    data_json = getJson(url)
    total = int(data_json['pageHelp']['pageCount'])
    return total


# 获取基金id列表
def getInfoList(page):
    info_list = []
    url = f'http://query.sse.com.cn/commonQuery.do?jsonCallBack=jsonpCallback51800&isPagination=true&bond_type=4&sqlId=COMMON_SSE_ZCZZQXMLB&pageHelp.pageSize=25&status=&begin=&end=&pageHelp.cacheSize=1&pageHelp.pageNo=1&pageHelp.beginPage={page}&_={int(time.time())}'
    data_json = getJson(url)
    data_json = data_json['result']
    for data in data_json:
        id = data['BOND_NUM']
        type = data['REITS_TYPE']
        if type == '0':
            info_list.append([id, '首次发售'])
        elif type == '1':
            info_list.append([id, '扩募发售'])
        else:
            info_list.append([id, '-'])
    return info_list


# 获取项目基本信息
def getBaseInfo(id, type):
    url = f'http://query.sse.com.cn/commonQuery.do?jsonCallBack=jsonpCallback72929&isPagination=false&audit_id={id}&sqlId=COMMON_SSE_ZCZZQXMXXXX&_={int(time.time()) * 1000}'
    try:
        data_ = getJson(url)['result'][0]
    except:
        log.error(f'{id}===项目基本信息获取失败')
        return {}
    if data_['AUDIT_STATUS'] == '0':
        audit_status = '已申报'
    elif data_['AUDIT_STATUS'] == '1':
        audit_status = '已受理'
    elif data_['AUDIT_STATUS'] == '2':
        audit_status = '已反馈'
    elif data_['AUDIT_STATUS'] == '3':
        audit_status = '已接收反馈意见'
    elif data_['AUDIT_STATUS'] == '4':
        audit_status = '通过'
    elif data_['AUDIT_STATUS'] == '5':
        audit_status = '未通过'
    elif data_['AUDIT_STATUS'] == '8':
        audit_status = '终止'
    elif data_['AUDIT_STATUS'] == '901':
        audit_status = '承销商/管理人超期中止'
    elif data_['AUDIT_STATUS'] == '9':
        audit_status = '中止'
    elif data_['AUDIT_STATUS'] == '10':
        audit_status = '已回复交易所意见'
    elif data_['AUDIT_STATUS'] == '111':
        audit_status = '提交注册'
    elif data_['AUDIT_STATUS'] == '12':
        audit_status = '注册生效'
    else:
        audit_status = '-'
    if data_['BOND_TYPE'] == '4':
        bond_type = '基础设施公募REITs'
    else:
        bond_type = '其它'
    strUpdateDate = data_['PUBLISH_DATE']
    if strUpdateDate == '-':
        updateDate = ''
    else:
        updateDate = datetime.strptime(data_['PUBLISH_DATE'], '%Y-%m-%d')
    strAccDate = data_['ACCEPT_DATE']
    if strAccDate == '-':
        accDate = ''
    else:
        accDate = datetime.strptime(data_['ACCEPT_DATE'], '%Y-%m-%d')
    sponsors = []
    sponsorMD5 = []
    if ',' in data_['LIST1']:
        for sponsor in data_['LIST1'].split(','):
            sponsors.append(sponsor)
    elif '，' in data_['LIST1']:
        for sponsor in data_['LIST1'].split('，'):
            sponsors.append(sponsor)
    elif ';' in data_['LIST1']:
        for sponsor in data_['LIST1'].split(';'):
            sponsors.append(sponsor)
    else:
        sponsors.append(data_['LIST1'])
    for sponsor in sponsors:
        sponsorMD5.append(md5_encrypt(sponsor))
    data = {
        'name': data_['AUDIT_NAME'],
        'variety': bond_type,
        'sponsor': data_['LIST1'],
        'sponsors':sponsors,
        'sponsorMD5':sponsorMD5,
        'caretaker': data_['PRIORITY_MANAGER'],
        'planName': data_['PRIORITY_NAME'],
        'planCaretaker': data_['LIST2'],
        'letterNum': data_['REG_APRV_WEN_HAO'],
        'status': audit_status,
        'updateDate': updateDate,
        'strUpdateDate': strUpdateDate,
        'accDate': accDate,
        'strAccDate': strAccDate,
        'type': type,
    }
    return data


# 获取信息披露文件及备查文件
def getFile(obsOperate, id, mongoId):
    data = {
        'fundContracts': {},
        'fundCustodianAgt': {},
        'prospectus': {},
        'legalOpinion': {},
    }
    url = f'http://query.sse.com.cn/commonQuery.do?jsonCallBack=jsonpCallback56354&isPagination=false&audit_id={id}&sqlId=COMMON_SSE_ZCZZQXMXXXX_XXPLWJ_ZGSMS&_={int(time.time()) * 1000}'
    try:
        data_json = getJson(url)['result']
    except:
        log.error(f'{id}===信息披露文件及备查文件获取失败')
        return 0
    for data_ in data_json:
        type = data_['FILE_TYPE']
        paths = data_['FILE_PATH'].split('|')
        versions = data_['FILE_VERSION'].split('|')
        times = data_['FILE_TIME'].split('|')
        names = data_['FILE_TITLE'].split('|')
        data_ = {
            'declaration': '',
            'declarationTime': '',
            'strDeclarationTime': '',
            'fdbkResp': '',
            'fdbkRespTime': '',
            'strFdbkRespTime': '',
            'cover': '',
            'coverTime': '',
            'strCoverTime': '',
        }
        for i in range(len(paths)):
            path = paths[i]
            version = versions[i]
            time_ = times[i]
            file_name = names[i]
            path = 'http://static.sse.com.cn/bond' + path
            category = os.path.splitext(path)[1]
            if category not in file_name:
                file_name = file_name + category
            retData = obsOperate.uptoOBS(path, mongoId, file_name)
            time.sleep(2)
            if retData['state']:
                pass
            else:
                log.error(f'{id}===信息披露文件及备查文件下载obs失败')
                return 0
            att_id, full_path = obsOperate.tableUpdate(retData, 'RETIs文件', file_name, i, time_)
            if int(version) == 1:
                data_['declaration'] = full_path
                data_['declarationTime'] = datetime.strptime(time_, '%Y-%m-%d')
                data_['strDeclarationTime'] = time_
            elif int(version) == 2:
                data_['fdbkResp'] = full_path
                data_['fdbkRespTime'] = datetime.strptime(time_, '%Y-%m-%d')
                data_['strFdbkRespTime'] = time_
            elif int(version) == 3:
                data_['cover'] = full_path
                data_['coverTime'] = datetime.strptime(time_, '%Y-%m-%d')
                data_['strCoverTime'] = time_
        if type == '91':
            data_['title'] = '基金合同'
            data['fundContracts'] = data_
        elif type == '92':
            data_['title'] = '基金托管协议'
            data['fundCustodianAgt'] = data_
        elif type == '93':
            data_['title'] = '招募说明书'
            data['prospectus'] = data_
        elif type == '94':
            data_['title'] = '基金法律意见书'
            data['legalOpinion'] = data_
    log.info(f'{id}===信息披露文件及备查文件采集成功')
    return data


# 获取反馈意见及回复
def getFeedback(obsOperate, id, mongoId):
    data = []
    url = f'http://query.sse.com.cn/commonQuery.do?jsonCallBack=jsonpCallback27109&isPagination=true&audit_id={id}&sqlId=COMMON_SSE_ZCZZQXMXXXX_FKXX_ALL&_={int(time.time()) * 1000}'
    try:
        data_json = getJson(url)['result']
    except:
        log.error(f'{id}===反馈意见及回复获取失败')
        return 0
    for data_ in data_json:
        num = data_['NUM']
        path = data_['FILE_PATH']
        path = 'http://static.sse.com.cn/bond' + path
        title = data_['FILE_TITLE']
        updateTime = data_['UPD_TIME']
        category = os.path.splitext(path)[1]
        if category not in title:
            title = title + category
        retData = obsOperate.uptoOBS(path, mongoId, title)
        time.sleep(2)
        if retData['state']:
            pass
        else:
            log.error(f'{id}===反馈意见及回复文件下载osb失败')
            return 0
        att_id, full_path = obsOperate.tableUpdate(retData, 'RETIs文件', title, num, updateTime)
        data_ = {
            'num': num,
            'title': title,
            'updateTime': datetime.strptime(updateTime, '%Y-%m-%d'),
            'strUpdateTime': updateTime,
            'filePath': full_path,
        }
        data.append(data_)
    log.info(f'{id}===反馈意见及回复采集成功')
    return data


def updateFilePath(obsOperate,paths,versions,times,names,mongoData,mongoId,type):
    data = {}
    for i in range(len(paths)):
        path = paths[i]
        version = versions[i]
        time_ = times[i]
        file_name = names[i]
        path = 'http://static.sse.com.cn/bond' + path
        category = os.path.splitext(path)[1]
        if category not in file_name:
            file_name = file_name + category
        if int(version) == 1:
            try:
                if time_ == mongoData['file'][f'{type}']['strDeclarationTime'] :
                    full_path = mongoData['file'][f'{type}']['declaration']
                else:
                    retData = obsOperate.uptoOBS(path, mongoId, file_name)
                    time.sleep(2)
                    if retData['state']:
                        pass
                    else:
                        log.error(f'{id}===信息披露文件及备查文件下载obs失败')
                        return 0
                    att_id, full_path = obsOperate.tableUpdate(retData, 'RETIs文件', file_name, i, time_)
            except:
                retData = obsOperate.uptoOBS(path, mongoId, file_name)
                time.sleep(2)
                if retData['state']:
                    pass
                else:
                    log.error(f'{id}===信息披露文件及备查文件下载obs失败')
                    return 0
                att_id, full_path = obsOperate.tableUpdate(retData, 'RETIs文件', file_name, i, time_)
            data['declaration'] = full_path
            data['declarationTime'] = datetime.strptime(time_, '%Y-%m-%d')
            data['strDeclarationTime'] = time_
        elif int(version) == 2:
            try:
                if time_ == mongoData['file'][f'{type}']['strFdbkRespTime'] :
                    full_path = mongoData['file'][f'{type}']['fdbkResp']
                else:
                    retData = obsOperate.uptoOBS(path, mongoId, file_name)
                    time.sleep(2)
                    if retData['state']:
                        pass
                    else:
                        log.error(f'{id}===信息披露文件及备查文件下载obs失败')
                        return 0
                    att_id, full_path = obsOperate.tableUpdate(retData, 'RETIs文件', file_name, i, time_)
            except:
                retData = obsOperate.uptoOBS(path, mongoId, file_name)
                time.sleep(2)
                if retData['state']:
                    pass
                else:
                    log.error(f'{id}===信息披露文件及备查文件下载obs失败')
                    return 0
                att_id, full_path = obsOperate.tableUpdate(retData, 'RETIs文件', file_name, i, time_)
            data['fdbkResp'] = full_path
            data['fdbkRespTime'] = datetime.strptime(time_, '%Y-%m-%d')
            data['strFdbkRespTime'] = time_
        elif int(version) == 3:
            try:
                if time_ == mongoData['file'][f'{type}']['strCoverTime']:
                    full_path = mongoData['file'][f'{type}']['cover']
                else:
                    retData = obsOperate.uptoOBS(path, mongoId, file_name)
                    time.sleep(2)
                    if retData['state']:
                        pass
                    else:
                        log.error(f'{id}===信息披露文件及备查文件下载obs失败')
                        return 0
                    att_id, full_path = obsOperate.tableUpdate(retData, 'RETIs文件', file_name, i, time_)
            except:
                retData = obsOperate.uptoOBS(path, mongoId, file_name)
                time.sleep(2)
                if retData['state']:
                    pass
                else:
                    log.error(f'{id}===信息披露文件及备查文件下载obs失败')
                    return 0
                att_id, full_path = obsOperate.tableUpdate(retData, 'RETIs文件', file_name, i, time_)
            data['cover'] = full_path
            data['coverTime'] = datetime.strptime(time_, '%Y-%m-%d')
            data['strCoverTime'] = time_
    return data


def updateFile(obsOperate, id, mongoId, mongoData):
    data = {
        'fundContracts': {},
        'fundCustodianAgt': {},
        'prospectus': {},
        'legalOpinion': {},
    }
    url = f'http://query.sse.com.cn/commonQuery.do?jsonCallBack=jsonpCallback56354&isPagination=false&audit_id={id}&sqlId=COMMON_SSE_ZCZZQXMXXXX_XXPLWJ_ZGSMS&_={int(time.time()) * 1000}'
    try:
        data_json = getJson(url)['result']
    except:
        log.error(f'{id}===信息披露文件及备查文件获取失败')
        return 0
    for data_ in data_json:
        type = data_['FILE_TYPE']
        paths = data_['FILE_PATH'].split('|')
        versions = data_['FILE_VERSION'].split('|')
        times = data_['FILE_TIME'].split('|')
        names = data_['FILE_TITLE'].split('|')
        if type == '91':
            data_2 = updateFilePath(obsOperate,paths,versions,times,names,mongoData,mongoId,'fundContracts')
            data_['title'] = '基金合同'
            data['fundContracts'] = data_2
        elif type == '92':
            data_2 = updateFilePath(obsOperate,paths,versions,times,names,mongoData,mongoId,'fundCustodianAgt')
            data_['title'] = '基金托管协议'
            data['fundCustodianAgt'] = data_2
        elif type == '93':
            data_2 = updateFilePath(obsOperate,paths,versions,times,names,mongoData,mongoId,'prospectus')
            data_['title'] = '招募说明书'
            data['prospectus'] = data_2
        elif type == '94':
            data_2 = updateFilePath(obsOperate,paths,versions,times,names,mongoData,mongoId,'legalOpinion')
            data_['title'] = '基金法律意见书'
            data['legalOpinion'] = data_2
    log.info(f'{id}===信息披露文件及备查文件采集成功')
    return data


def updateFeedback(obsOperate, id, mongoId, mongoData):
    data = []
    url = f'http://query.sse.com.cn/commonQuery.do?jsonCallBack=jsonpCallback27109&isPagination=true&audit_id={id}&sqlId=COMMON_SSE_ZCZZQXMXXXX_FKXX_ALL&_={int(time.time()) * 1000}'
    try:
        data_json = getJson(url)['result']
    except:
        log.error(f'{id}===反馈意见及回复获取失败')
        return 0
    for data_ in data_json:
        num = data_['NUM']
        path = data_['FILE_PATH']
        path = 'http://static.sse.com.cn/bond' + path
        title = data_['FILE_TITLE']
        updateTime = data_['UPD_TIME']
        category = os.path.splitext(path)[1]
        if category not in title:
            title = title + category
        flg = True
        for feedback_ in mongoData['feedback']:
            if updateTime == feedback_['strUpdateTime'] and title == feedback_['title']:
                data.append(feedback_)
                flg = False
                break
        if flg:
            retData = obsOperate.uptoOBS(path, mongoId, title)
            time.sleep(2)
            if retData['state']:
                pass
            else:
                log.error(f'{id}===反馈意见及回复文件下载osb失败')
                return 0
            att_id, full_path = obsOperate.tableUpdate(retData, 'RETIs文件', title, num, updateTime)
            data_ = {
                'num': num,
                'title': title,
                'updateTime': datetime.strptime(updateTime, '%Y-%m-%d'),
                'strUpdateTime': updateTime,
                'filePath': full_path,
            }
            data.append(data_)
    log.info(f'{id}===反馈意见及回复采集成功')
    return data


def doJob(obsOperate):
    log.info('采集开始')
    try:
        total = getTotal()
    except:
        log.error(f'总页数获取失败')
        return
    for page in range(1, total + 1):
        log.info(f'开始采集第{page}页')
        try:
            info_list = getInfoList(page)
        except:
            log.error(f'第{page}页数据获取失败')
            continue
        for info in info_list:
            id = info[0]
            type = info[1]
            baseInfo = getBaseInfo(id, type)
            is_insert = db_storage.find_one({'baseInfo.name': f'{baseInfo["name"]}', 'exchange': '上海证券交易所'})
            if is_insert:
                mongoId = is_insert['_id']
                updateDate = is_insert['baseInfo']['strUpdateDate']
                if updateDate == baseInfo['strUpdateDate']:
                    log.info(f'{baseInfo["name"]}===已采集,不需要更新')
                    time.sleep(5)
                    continue
                else:
                    log.info(f'{id}===已采集,需要更新,正在更新中')
                    createDate = is_insert['createDate']
                    now = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
                    file = updateFile(obsOperate, id, str(mongoId), is_insert)
                    feedback = updateFeedback(obsOperate, id, str(mongoId), is_insert)
                    dic_info = {
                        'baseInfo': baseInfo,
                        'file': file,
                        'feedback': feedback,
                        'exchange': '上海证券交易所',
                        'updateDate': now,
                        'createDate': createDate,
                    }
                    try:
                        db_storage.update_one({'_id': mongoId}, {'$set': dic_info})
                        log.info(f'{id}===更新成功')
                    except:
                        log.error(f'{id}===更新失败')
            else:
                dic_info = {
                    'baseInfo': baseInfo,
                    'exchange': '上海证券交易所'
                }
                try:
                    db_storage.insert_one(dic_info)
                    log.info(f'{baseInfo["name"]}===初次入库成功')
                except:
                    log.error(f'{baseInfo["name"]}===初次入库失败')
                    continue
                mongoId = db_storage.find_one({'baseInfo.name': f'{baseInfo["name"]}', 'exchange': '上海证券交易所'})['_id']
                file = getFile(obsOperate, id, str(mongoId))
                feedback = getFeedback(obsOperate, id, str(mongoId))
                if not baseInfo or file == 0 or feedback == 0:
                    db_storage.delete_one({'_id': mongoId})
                    log.error(f'{id}===数据采集不完整,初次入库数据已删除')
                    continue
                now = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
                dic_info = {
                    'baseInfo': baseInfo,
                    'file': file,
                    'feedback': feedback,
                    'exchange': '上海证券交易所',
                    'updateDate':now,   # 修改日期
                    'createDate':now    # 创建日期
                }
                try:
                    db_storage.update_one({'_id': mongoId}, {'$set': dic_info})
                    log.info(f'{id}===保存成功')
                except:
                    db_storage.delete_one({'_id': mongoId})
                    log.error(f'{id}===二次入库失败,已删除')
                time.sleep(3)


if __name__ == '__main__':
    obsOperate = obsOperate(cursor_, cnx_, log)
    doJob(obsOperate)
    baseCore.close()