package com.zzsn.code.base.core.util.objutil;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

/**
 * Description:
 *
 * @author: EDY
 * @since: 2023/12/27
 */
public class ObjectUtils {

    public static boolean isNotEmpty(final Object object) {
        return !isEmpty(object);
    }

    public static boolean isEmpty(final Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof CharSequence) {
            return ((CharSequence) object).length() == 0;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        if (object instanceof Collection<?>) {
            return ((Collection<?>) object).isEmpty();
        }
        if (object instanceof Map<?, ?>) {
            return ((Map<?, ?>) object).isEmpty();
        }
        return false;
    }
}
