package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.SubjectAddition;
import com.zzsn.event.vo.EnterpriseCondition;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 专题其他来源数据
 * @Author: jeecg-boot
 * @Date:   2023-10-26
 * @Version: V1.0
 */
public interface SubjectAdditionMapper extends BaseMapper<SubjectAddition> {

    List<String> enterpriseListId(String name, Integer listType, Integer year);

    List<String> pageList(@Param("enterpriseCondition") EnterpriseCondition enterpriseCondition);

    List<String>pageListByOther(@Param("enterpriseCondition") EnterpriseCondition enterpriseCondition);

    List<String> pageListByLabelIds(EnterpriseCondition enterpriseCondition);

    List<SubjectAddition> pageListBySubjectIdAndType(String subjectId, int type, int offset, Integer pageSize);

    int count(String subjectId, int type);
}
