package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.LabelEntity;
import com.zzsn.event.enums.LabelTypeEnum;
import com.zzsn.event.mapper.LabelEntityMapper;
import com.zzsn.event.service.LabelEntityService;
import com.zzsn.event.service.SysBaseLabelTypeService;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.util.tree.TreeUtil;
import com.zzsn.event.vo.LabelTypeVO;
import com.zzsn.event.vo.SysLabelVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author lkg
 * @date 2023/3/2
 */
@Service
public class LabelEntityServiceImpl extends ServiceImpl<LabelEntityMapper, LabelEntity> implements LabelEntityService {

    @Autowired
    private SysBaseLabelTypeService labelTypeService;
    @Override
    public Object pageList(SysLabelVo sysLabelVo, Integer pageNo, Integer pageSize) {
        Page<SysLabelVo> page = new Page<>(pageNo, pageSize);
        String labelType = sysLabelVo.getLabelType();
        String labelMark = sysLabelVo.getLabelMark();
        List<String> labelIds = labelTypeService.belowList(sysLabelVo.getLabelTypeId());
        if (LabelTypeEnum.ENTERPRISE.getValue().equals(labelType)) {
            return baseMapper.queryCompanyLabel(labelIds,sysLabelVo.getName(),page);
        } else if (LabelTypeEnum.CHARACTER.getValue().equals(labelType)) {
            return baseMapper.queryGovernmentLeaders(labelIds,sysLabelVo.getName(),page);
        } else if (LabelTypeEnum.INDUSTRY.getValue().equals(labelType)) {
            return this.industryTree();
        } else if (LabelTypeEnum.REGION.getValue().equals(labelType)) {
            if ("region_in".equals(labelMark)) {
                return this.regionTree(2);
            } else if ("region_out".equals(labelMark)) {
                return this.regionTree(1);
            }
        } else  {
            return baseMapper.queryCustomLabel(labelIds,sysLabelVo.getName(),page);
        }
        return null;
    }

    @Override
    public List<LabelEntity> listByType(String labelTypeId) {
        return baseMapper.listByType(labelTypeId);
    }

    @Override
    public List<LabelTypeVO> regionTree(Integer type) {
        List<LabelTypeVO> nodes;
        if (type == 1) {
            nodes = baseMapper.regionOutList();
        } else {
            nodes = baseMapper.regionInList(null);
        }
        return TreeUtil.tree(nodes,ROOT_ID);
    }

    @Override
    public List<LabelTypeVO> firstLevelRegions() {
        return baseMapper.regionInList(1);
    }

    @Override
    public List<LabelTypeVO> industryTree() {
        List<LabelTypeVO> nodes = baseMapper.industryList();
        return TreeUtil.tree(nodes,ROOT_ID);
    }
}
