package com.zzsn.event.exception;

import com.zzsn.event.constant.Result;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * 异常拦截
 *
 * @author lkg
 * @date 2025/2/28
 */
@RestControllerAdvice
public class CustomExceptionHandler {

    @ExceptionHandler(FileExportException.class)
    public ResponseEntity<Object> handleFileExportException(FileExportException ex) {
        return new ResponseEntity<>(Result.FAIL(ex.getMessage()), HttpStatus.valueOf(ex.getStatusCode()));
    }
}
