package com.zzsn.event.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.Subject;
import com.zzsn.event.es.EsService;
import com.zzsn.event.service.SubjectService;
import com.zzsn.event.service.SubjectSimpleService;
import com.zzsn.event.vo.InfoDataSearchCondition;
import com.zzsn.event.vo.SubjectDetailVO;
import com.zzsn.event.vo.SubjectSimpleVO;
import com.zzsn.event.vo.es.SpecialInformation;
import com.zzsn.event.xxljob.service.IXxlJobInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

/**
 * 专题管理流程简化版
 *
 * @author lkg
 * @date 2025/1/9
 */@Slf4j
@RestController
@RequestMapping("/subject/simple")
public class SubjectSimpleController {

    @Autowired
    private SubjectSimpleService subjectSimpleService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private IXxlJobInfoService xxlJobInfoService;
    @Autowired
    private EsService esService;

    /**
     * 创建专题
     *
     * @param subjectSimpleVO 参数
     * @author lkg
     * @date 2025/1/9
     */
    @PostMapping("/createSubject")
    public Result<?> createSubject(@RequestBody SubjectSimpleVO subjectSimpleVO) {
        Subject subject = subjectSimpleService.createSubject(subjectSimpleVO);
        //插入xxlJob
        xxlJobInfoService.subjectInsert(subject);
        return Result.OK(subject.getId());
    }

    /**
     * 编辑专题
     *
     * @param subjectSimpleVO 参数
     * @author lkg
     * @date 2025/1/9
     */
    @PostMapping("/editSubject")
    public Result<?> editSubject(@RequestBody SubjectSimpleVO subjectSimpleVO) {
        subjectSimpleService.editSubject(subjectSimpleVO);
        return Result.OK();
    }

    /**
     * 专题详情(包含样例文章以及关键词)
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/1/9
     */
    @GetMapping("/queryInfo")
    public Result<?> queryInfo(@RequestParam String subjectId){
        SubjectDetailVO subjectDetailVO = subjectSimpleService.queryInfo(subjectId);
        return Result.OK(subjectDetailVO);
    }

    /**
     * 删除专题
     *
     * @param subjectId 专题id
     * @return
     */
    @GetMapping(value = "/removeSubject")
    public Result<?> removeSubject(@RequestParam String subjectId) {
        subjectSimpleService.removeSubject(subjectId);
        CompletableFuture.runAsync(() -> {
            //删除xxljob里面的信息
            LambdaQueryWrapper<Subject> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(Subject::getId, subjectId);
            Subject subject = subjectService.getOne(queryWrapper);
            xxlJobInfoService.deleteByInfosourceCode(subject.getSubjectCode());
        });
        return Result.OK();
    }


    /**
     * 批量添加至精选
     *
     * @param searchCondition 检索条件
     * @author lkg
     * @date 2025/1/14
     */
    @PostMapping("/selected")
    public Result<?> selected(@RequestBody InfoDataSearchCondition searchCondition) {
        subjectSimpleService.selected(searchCondition);
        return Result.OK();
    }

    /**
     * 批量移除精选
     *
     * @param searchCondition 检索条件
     * @author lkg
     * @date 2025/1/14
     */
    @PostMapping("/removeSelected")
    public Result<?> removeSelected(@RequestBody InfoDataSearchCondition searchCondition) {
        subjectSimpleService.removeSelected(searchCondition);
        return Result.OK();
    }

    /**
     * 批量删除
     *
     * @param searchCondition 检索条件
     * @author lkg
     * @date 2025/1/14
     */
    @PostMapping("/batchRemove")
    public Result<?> batchRemove(@RequestBody InfoDataSearchCondition searchCondition) {
        subjectSimpleService.batchRemove(searchCondition);
        return Result.OK();
    }
}
