package com.zzsn.event.service.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.SysDictItem;
import com.zzsn.event.mapper.SysDictItemMapper;
import com.zzsn.event.service.SysDictItemService;
import com.zzsn.event.vo.CountVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @Author zhangweijian
 * @since 2018-12-28
 */
@Service
@DS("multi-datasource2")
public class SysDictItemServiceImpl extends ServiceImpl<SysDictItemMapper, SysDictItem> implements SysDictItemService {

    @Override
    public List<SysDictItem> listByDictCode(String dictCode) {
        return this.baseMapper.listByDictCode(dictCode);
    }


        @Override
    public void changeKey(List<CountVO> dataList, List<SysDictItem> dictItemList) {
        if (CollectionUtils.isNotEmpty(dataList)) {
            Map<String, List<SysDictItem>> map = dictItemList.stream().collect(Collectors.groupingBy(SysDictItem::getItemValue));
            for (CountVO countVO : dataList) {
                String name = countVO.getName();
                List<SysDictItem> sysDictItemList = map.get(name);
                if (CollectionUtils.isNotEmpty(sysDictItemList)) {
                    countVO.setName(sysDictItemList.get(0).getItemText());
                    map.remove(name);
                }
            }
            if (MapUtils.isNotEmpty(map)) {
                dataList.addAll(map.values().stream().map(e -> {
                    CountVO countVO = new CountVO();
                    countVO.setName(e.get(0).getItemText());
                    countVO.setValue(0L);
                    return countVO;
                }).collect(Collectors.toList()));
            }
        } else {
            for (SysDictItem sysDictItem : dictItemList) {
                CountVO countVO = new CountVO();
                countVO.setName(sysDictItem.getItemText());
                countVO.setValue(0L);
                dataList.add(countVO);
            }
        }
    }
}
