package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.SubjectTypeMap;
import com.zzsn.event.mapper.SubjectTypeMapMapper;
import com.zzsn.event.service.ISubjectTypeMapService;
import com.zzsn.event.util.user.AuthUtil;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Description: 专题与类别关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-01
 * @Version: V1.0
 */
@Service
public class SubjectTypeMapServiceImpl extends ServiceImpl<SubjectTypeMapMapper, SubjectTypeMap> implements ISubjectTypeMapService {

    @Override
    public void deleteBySubjectId(String subjectId) {
        baseMapper.deleteBySubjectId(subjectId);
    }

    @Override
    public List<String> selectSubjectByTypeIds(List<String> typeIds) {
        return baseMapper.selectSubjectByTypeIds(typeIds, AuthUtil.getAuthUserId());
    }

    @Override
    public List<String> selectEventByTypeIds(List<String> typeIds) {
        return baseMapper.selectEventByTypeIds(typeIds, AuthUtil.getAuthUserId());
    }
}
