package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 流程编排-专题关联
 *
 * @author lkg
 * @date 2025/1/13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("clb_model_arrange_subject_map")
public class ClbModelArrangeSubjectMap {

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 专题id
     */
    @TableField("subject_id")
    private String subjectId;

    /**
     * 流程id
     */
    @TableField("arrange_id")
    private String arrangeId;

    /**
     * 匹配类型 信息源、定向信息源、企业库等
     */
    @TableField("type")
    private String type;

    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 删除标志 0-正常 1-删除
     */
    @TableField("del_flag")
    private Integer delFlag;

    /**
     * 创建日期
     */
    @TableField("create_time")
    private Date createTime;

    /**
     * 更新人
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 更新日期
     */
    @TableField("update_time")
    private Date updateTime;
}
