package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.SubjectModelMap;
import com.zzsn.event.mapper.SubjectModelMapMapper;
import com.zzsn.event.service.ISubjectModelMapService;
import com.zzsn.event.vo.PythonModelVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Description: 专题与模型关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-16
 * @Version: V1.0
 */
@Service
public class SubjectModelMapServiceImpl extends ServiceImpl<SubjectModelMapMapper, SubjectModelMap> implements ISubjectModelMapService {

    @Override
    public List<SubjectModelMap> selectModelBySubjectId(String subjectId){
        return baseMapper.selectModelBySubjectId(subjectId);
    }

    @Override
    public List<PythonModelVo> bindModelByType(String subjectId, String type) {
        List<PythonModelVo> pythonModelVos = baseMapper.bindModelByType(subjectId,type);
        for(PythonModelVo pythonModelVo : pythonModelVos){
            if(StringUtils.isNotEmpty(pythonModelVo.getSubjectId())){
                pythonModelVo.setYn("1");
            }
        }
        return pythonModelVos;
    }
}
