package com.zzsn.event.entity;

import com.zzsn.event.vo.SubjectKeywordsMap;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description: 专题相关表（数据同步使用）
 * @Author: yanxin
 * @Date:   2023-06-12
 * @Version: V1.0
 */
@Data
public class SubjectAboutTable implements Serializable {
    private static final long serialVersionUID = 1L;

    /**专题直接关联部分begin*/
    private List<Subject> subject = new ArrayList<>();
    private List<SubjectKeywords> subjectKeywords = new ArrayList<>();
    private List<SubjectKeywordsMap> subjectKeywordsMap = new ArrayList<>();
    private List<SubjectModelMap> subjectModelMap = new ArrayList<>();
    private List<SubjectSearchEnginesMap> subjectSearchEnginesMap = new ArrayList<>();
    /**专题直接关联部分end*/
    /**专题分类部分begin*/
    private List<SubjectTypeMap> subjectTypeMap = new ArrayList<>();
    private List<SubjectType> subjectType = new ArrayList<>();
    /**专题分类部分end*/
    /**信息源以及信息源组部分begin*/
    private List<InfoSource> infoSource = new ArrayList<>();
    private List<SubjectInfoSourceMap> subjectInfoSourceMap = new ArrayList<>();
    private List<InfoSourceGroup> infoSourceGroup = new ArrayList<>();
    private List<InfoSourceGroupMap> infoSourceGroupMap = new ArrayList<>();
    private List<GroupType> groupType = new ArrayList<>();
    private List<GroupTypeMap> groupTypeMap = new ArrayList<>();
    /**信息源以及信息源组部分end*/
}
