package com.zzsn.event.entity;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zzsn.event.enums.AnalysisColumnEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 事件分析版本记录表
 *
 * @TableName event_analysis_version_record
 */
@Data
@TableName("event_analysis_version_record")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class EventAnalysisVersionRecord implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;
    /**
     * 版本id
     */
    private String versionId;
    /**
     * 栏目编码
     */
    private Integer columnCode;
    /**
     * 参数
     */
    private String params;
    /**
     * 返回数据
     */
    private String returnData;
    /**
     * 返回数据类型(object、array)
     */
    private String resType;
    /**
     * 创建人
     */
    private String createBy;
    /**
     * 创建时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**
     * 更新人
     */
    private String updateBy;
    /**
     * 更新时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;


    public static EventAnalysisVersionRecord of(String versionId, AnalysisColumnEnum analysisColumnEnum, String returnData) {
        EventAnalysisVersionRecord record = new EventAnalysisVersionRecord();
        record.setVersionId(versionId);
        record.setColumnCode(analysisColumnEnum.getCode());
        record.setReturnData(returnData);
        record.setResType(analysisColumnEnum.getResType());
        return record;
    }
}
