package com.zzsn.event.controller.python;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.EventContext;
import com.zzsn.event.service.EventContextService;
import jdk.internal.org.objectweb.asm.Handle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * python推送数据
 *
 * @author lkg
 * @date 2025/8/5
 */
@RestController
@RequestMapping("/python/send")
public class AnalysisDataController {

    @Autowired
    private EventContextService eventContextService;

    @Value("${scheduling.yjzxEnable:false}")
    Boolean yjzxEnable;

    @GetMapping("/eventContext")
    public Result<?> sendEventContext(@RequestParam String eventId) {
        Map<String, Object> map = new HashMap<>();
        map.put("ynYjzx",yjzxEnable);
        LambdaQueryWrapper<EventContext> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(EventContext::getEventId, eventId).orderByDesc(EventContext::getSortNumber);
        List<EventContext> eventContexts = eventContextService.list(queryWrapper);
        map.put("data", eventContexts);
        return Result.OK(map);
    }
}
