package com.zzsn.event.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.zzsn.event.vo.es.SpecialInformation;
import com.zzsn.event.vo.log.Source;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * python工具类
 *
 * @author lkg
 * @date 2025/1/23
 */
@Slf4j
@Service
public class PythonUtil {

    @Value("${python.keyWordsExtractUrl}")
    private String keywordExtractUrl;
    @Value("${python.judgeDuplicateUrl:}")
    private String judgeDuplicateUrl;
    @Value("${python.clearDuplicateHistoryUrl:}")
    private String clearDuplicateHistoryUrl;
    @Value("${python.enterpriseCaseFilterUrl:}")
    private String enterpriseCaseFilterUrl;

    /**
     * 提取关键词
     *
     * @param content 文本内容
     * @param number  提取的关键词数量
     * @author lkg
     * @date 2025/1/23
     */
    public List<String> extractKeyword(String content, Integer number) {
        List<String> wordsList = new ArrayList<>();
        if (StringUtils.isNotBlank(content)) {
            Map<String, Object> params = new HashMap<>();
            params.put("text", content);
            params.put("name", "phrase");
            params.put("topK", number.toString());
            String result = HttpUtil.doPostForm(keywordExtractUrl, params, 60000);
            JSONObject jsonObject = JSONObject.parseObject(result);
            JSONObject resultData = jsonObject.getJSONObject("resultData");
            if (resultData != null) {
                JSONArray data = resultData.getJSONArray("data");
                wordsList = JSON.parseArray(data.toString(), String.class);
            }
        }
        return wordsList;
    }

    /**
     * 判重
     *
     * @param id            资讯id
     * @param title         资讯标题
     * @param content       资讯内容
     * @param sourceAddress 原文链接
     * @param subjectId     专题id
     * @author lkg
     * @date 2025/2/7
     */
    public Boolean judgeDuplicate(String id, String title, String content, String sourceAddress, String subjectId) {
        boolean repeat = false;
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/json;charset=UTF-8");
        headers.put("Accept", "application/json");
        headers.put("Authorization", "!0gwY$5S@5V&A_+XEu)");
        JSONObject jsonObjectParam = new JSONObject();
        jsonObjectParam.put("id", id);
        jsonObjectParam.put("title", title);
        jsonObjectParam.put("content", content);
        jsonObjectParam.put("sourceAddress", sourceAddress);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(jsonObjectParam);
        JSONObject paramObject = new JSONObject();
        paramObject.put("data", jsonArray);
        paramObject.put("hash_name", subjectId);
        try {
            String result = HttpUtil.doPostWithHeader(judgeDuplicateUrl, paramObject, 3000, headers);
            if (StringUtils.isNotEmpty(result)) {
                JSONObject jsonObject = JSONObject.parseObject(result);
                if (StringUtils.isNotEmpty(jsonObject.getString("resultData")) && !jsonObject.getJSONArray("resultData").isEmpty()) {
                    JSONObject resultObject = (JSONObject) jsonObject.getJSONArray("resultData").get(0);
                    repeat = resultObject.getBoolean("duplicated");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return repeat;
    }

    /**
     * 清空去重服务历史数据
     *
     * @param subjectIds 专题id集合
     * @author lkg
     * @date 2025/2/10
     */
    public void clearDuplicateHistory(List<String> subjectIds) {
        JSONObject params = new JSONObject();
        params.put("subjectId", subjectIds);
        Map<String,String> headers = new HashMap<>();
        headers.put("Content-Type", "application/json;charset=UTF-8");
        headers.put("Accept", "application/json");
        headers.put("Authorization", "!0gwY$5S@5V&A_+XEu)");
        try {
            String response =  HttpUtil.doPostWithHeader(clearDuplicateHistoryUrl, params,30000 , headers);
            JSONObject jsonObject = JSONObject.parseObject(response);
            String isHandleSuccess = jsonObject.getString("isHandleSuccess");
            if (isHandleSuccess.equals("true")) {
                log.info("专题-{}，清空数据，调用python接口清空去重服务历史数据请求发送成功",JSON.toJSONString(subjectIds));
            } else {
                log.info("python清空去重服务历史数据接口异常：{}",jsonObject.getString("logs"));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 企业案例资讯过滤
     *
     * @param infoList 企业资讯
     * @author lkg
     * @date 2025/9/18
     */
    public List<SpecialInformation> enterpriseCaseFilter(List<SpecialInformation> infoList) {
        List<SpecialInformation> resultList = new ArrayList<>();
        JSONObject params = new JSONObject();
        Map<String,Object> dataMap = new HashMap<>();
        List<JSONObject> dataList = new ArrayList<>();
        for (SpecialInformation specialInformation : infoList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id",specialInformation.getId());
            jsonObject.put("title",specialInformation.getTitle());
            jsonObject.put("content",specialInformation.getContent());
            jsonObject.put("origin",specialInformation.getOrigin());
            dataList.add(jsonObject);
        }
        dataMap.put("data_list",dataList);
        params.put("data",dataMap);
        try {
            String response = HttpUtil.doPost(enterpriseCaseFilterUrl, params, 300000);
            JSONObject jsonObject = JSONObject.parseObject(response);
            String isHandleSuccess = jsonObject.getString("isHandleSuccess");
            if (isHandleSuccess.equals("true")) {
                String resultData = jsonObject.getString("resultData");
                resultList = JSON.parseArray(resultData, SpecialInformation.class);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return resultList;
    }
}
