package com.zzsn.event.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.entity.*;
import com.zzsn.event.enums.BindTypeEnum;
import com.zzsn.event.external.entity.ExternalSubjectInfoSourceMap;
import com.zzsn.event.external.service.ExternalSubjectInfoSourceMapService;
import com.zzsn.event.feign.api.RemoteModelService;
import com.zzsn.event.mapper.SubjectAdditionMapper;
import com.zzsn.event.service.*;
import com.zzsn.event.vo.KeyWordsPage;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class ConfigurationMessageService {


    public static enum MessageType {

        INFOSOURCE_GROUP("INFOSOURCE_GROUP","信息源组"),
        INFOSOURCE("INFOSOURCE","信息源"),
        INFOSOURCE_LABEL("INFOSOURCE_LABEL","信息源标签"),
        ;

        public List<MessageType> getAll (){
            return  Arrays.asList(MessageType.values());
        }

        public String getCode() {
            return code;
        }

        public String getName() {
            return name;
        }

        MessageType(String code, String name) {
            this.code = code;
            this.name = name;
        }

        /**服务编码*/
        private final String code;
        /**服务名*/
        private final String name;
    }



    public static enum OptionType {


        BIND("BIND","绑定",0),
        UNBIND("UNBIND","解绑",1),
        ;

        public List<OptionType> getAll (){
            return  Arrays.asList(OptionType.values());
        }

        public String getCode() {
            return code;
        }

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        OptionType(String code, String name,Integer value) {
            this.code = code;
            this.name = name;
            this.value = value;
        }

        /**编码*/
        private final String code;
        /**名称*/
        private final String name;
        /**值*/
        private final Integer value;
    }

    @Autowired
    private IInfoSourceService infoSourceService;
    @Autowired
    private InfoSourceGroupService infoSourceGroupService;
    @Autowired
    private ISubjectInfoSourceMapService iSubjectInfoSourceMapService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private IEventService eventService;
    @Autowired
    private IInfoSourceService iInfoSourceService;

    @Autowired
    private IKeyWordsService keyWordsService;
    @Autowired
    private CaiJiCenterHttpService caiJiCenterHttpService;

    @Autowired
    ClbLabelInfoSourceMapService clbLabelInfoSourceMapService;
    @Autowired
    private SubjectAdditionMapper subjectAdditionMapper;

    @Autowired
    private ClbLabelEnterpriseMapService clbLabelEnterpriseMapService;

    @Autowired(required = false)
    private RemoteModelService remoteModelService;

    @Autowired
    private ExternalSubjectInfoSourceMapService externalSubjectInfoSourceMapService;

    public void bindKeyWordsSend(String subjectId,Integer type) {
        try {
            remoteModelService.delSubjectCache(subjectId);
        } catch (Exception e) {
            log.error("删除专题缓存失败{}",e.getMessage(),e);
        }
        Subject byId = subjectService.getSubjectOrEventById(subjectId);
        if (byId == null || byId.getStatus() == null || byId.getStatus() != 1) {
            log.info("未查询到专题或专题未启用");
            return;
        }
        List<String> subjectIdList = new ArrayList<>();
        subjectIdList.add(subjectId);
        List<KeyWordsPage> keyWordsPages = subjectService.bindKeyWordsListByIdsAndBindType(subjectIdList,"1",1);
        String keyWordsParam;
        if (CollectionUtil.isEmpty(keyWordsPages)) {
            log.info("专题未绑定采集词组,通知采集清空");
            keyWordsParam = getKeyWordsParam(byId, null, new ArrayList<>(),type);
        }else {
            List<KeyWords> keyWords = keyWordsService.listByIds(keyWordsPages.stream().map(KeyWordsPage::getId).collect(Collectors.toList()));
            keyWordsParam = getKeyWordsParam(byId, null, keyWords,type);
        }

        String post = caiJiCenterHttpService.allKeyWordsBindUrl(keyWordsParam);
        JSONObject entries = JSONUtil.parseObj(post);
        //获取code状态码
        Integer code = entries.getInt("code");
        if (ObjectUtil.isEmpty(code) ||  code != 200) {
            log.error("专题关键词配置通知采集失败{}",post);
            throw new RuntimeException("专题关键词配置通知采集失败");
        }
        log.info("{}专题关键词配置通知采集结束",byId.getSubjectName());
    }
    public void bindKeyWordsEventSend(String eventId) {
        Event byId = eventService.getById(eventId);
        if (byId == null || byId.getStatus() == null || byId.getStatus() != 1) {
            log.info("未查询到事件或事件未启用");
            return;
        }
        List<String> subjectIdList = new ArrayList<>();
        subjectIdList.add(eventId);
        List<KeyWordsPage> keyWordsPages = subjectService.bindKeyWordsListByIdsAndBindType(subjectIdList,null,1);
        String keyWordsParam;
        if (CollectionUtil.isEmpty(keyWordsPages)) {
            log.info("事件未绑定采集词组,通知采集清空");
            keyWordsParam = getEventKeyWordsParam(byId, null, new ArrayList<>());
        }else {
            List<KeyWords> keyWords = keyWordsService.listByIds(keyWordsPages.stream().map(KeyWordsPage::getId).collect(Collectors.toList()));
            keyWordsParam = getEventKeyWordsParam(byId, null, keyWords);
        }

        String post = caiJiCenterHttpService.allKeyWordsBindUrl(keyWordsParam);
        JSONObject entries = JSONUtil.parseObj(post);
        //获取code状态码
        Integer code = entries.getInt("code");
        if (ObjectUtil.isEmpty(code) ||  code != 200) {
            log.error("事件关键词配置通知采集失败{}",post);
            throw new RuntimeException("事件关键词配置通知采集失败");
        }
        log.info("{}事件关键词配置通知采集结束",byId.getEventName());
    }


    public void bindInfoSourceSend(String subjectId){
        try {
            remoteModelService.delSubjectCache(subjectId);
        } catch (Exception e) {
            log.error("删除专题缓存失败{}",e.getMessage(),e);
        }
        Subject byId = subjectService.getSubjectOrEventById(subjectId);
        if (byId == null || byId.getStatus() == null || byId.getStatus() != 1) {
            log.info("未查询到专题或专题未启用");
            return;
        }
        //只有启用状态的专题才需要通知采集更新绑定数据
        List<String> bindIds = getAllInfoSourceIds(subjectId);
        String getparam ;
        if (CollectionUtil.isNotEmpty(bindIds)) {
            getparam = getparam(byId, null, bindIds);
        }else {
            log.info("专题未绑定信息源,通知采集清空");

            getparam = getparam(byId, null, new ArrayList<>());
        }
        String post = caiJiCenterHttpService.allInfosourcebindUrl(getparam);
        JSONObject entries = JSONUtil.parseObj(post);
        //获取code状态码
        Integer code = entries.getInt("code");
        if (ObjectUtil.isEmpty(code) ||  code != 200) {
            log.error("专题信息源配置通知采集失败{}",post);
            throw new RuntimeException("专题信息源配置通知采集失败");
        }
        log.info("{}专题信息源配置通知采集结束",byId.getSubjectName());
    }


    public void sendEditKeyWordsConfigurationMessage(String keyWordId) {
        KeyWords byId = keyWordsService.getById(keyWordId);
        Map<String,Object> param = new HashMap<>();
        param.put("customerSign",caiJiCenterHttpService.getProjectCode());
        param.put("customerName",caiJiCenterHttpService.getProjectName());
        param.put("keywordSign",byId.getId());
        param.put("collectWordExp",byId.getKeyWord());
        String post = caiJiCenterHttpService.keyWordsEditUrl(param);
        JSONObject entries = JSONUtil.parseObj(post);
        //获取code状态码
        Integer code = entries.getInt("code");
        if (ObjectUtil.isEmpty(code) ||  code != 200) {
            log.error("编辑关键词通知采集失败{}",post);
            throw new RuntimeException("编辑关键词通知采集失败");
        }
    }

    public void subjectEnterpriseSourceSync(String subjectId){
        Subject subject = subjectService.getSubjectOrEventById(subjectId);
        if (subject == null || subject.getStatus() == null || subject.getStatus() != 1) {
            log.info("未查询到专题或专题未启用");
            return;
        }
        try {
            remoteModelService.delSubjectCache(subjectId);
        } catch (Exception e) {
            log.error("删除专题缓存失败{}",e.getMessage(),e);
        }
        List<SubjectAddition> resu = new ArrayList<>();

        //获取专题配置的企业来源
        List<SubjectAddition> subjectAdditionsEn = subjectAdditionMapper.selectList(Wrappers.<SubjectAddition>lambdaQuery()
                .eq(SubjectAddition::getSubjectId, subject.getId())
                .eq(SubjectAddition::getAdditionType, 4));

        if (CollectionUtil.isNotEmpty(subjectAdditionsEn)) {
            resu.addAll(subjectAdditionsEn);
        }

        List<SubjectAddition> subjectAdditionsEn5 = subjectAdditionMapper.selectList(Wrappers.<SubjectAddition>lambdaQuery()
                .eq(SubjectAddition::getSubjectId, subject.getId())
                .eq(SubjectAddition::getAdditionType, 5));
        if (CollectionUtil.isNotEmpty(subjectAdditionsEn5)) {
            List<String> itemCodes = subjectAdditionsEn5.stream().map(SubjectAddition::getAdditionRelationId).collect(Collectors.toList());
            List<String> labelCodes = subjectAdditionsEn5.stream().map(SubjectAddition::getAdditionDataType).collect(Collectors.toList());
            List<String> socCodes = clbLabelEnterpriseMapService.list(Wrappers.<ClbLabelEnterpriseMap>lambdaQuery()
                            .in(ClbLabelEnterpriseMap::getLabelItemCode, itemCodes)
                            .in(ClbLabelEnterpriseMap::getLabelCode, labelCodes))
                    .stream().map(ClbLabelEnterpriseMap::getEntityCode).distinct().collect(Collectors.toList());
            List<SubjectAddition> subjectAdditionsEn5Res = new ArrayList<>();
            if (CollectionUtil.isNotEmpty(socCodes)) {
                socCodes.forEach(e -> {
                    SubjectAddition subjectAddition = new SubjectAddition();
                    subjectAddition.setAdditionRelationId(e);
                    subjectAddition.setAdditionType(4);
                    subjectAddition.setSubjectId(subject.getId());

                    subjectAdditionsEn5Res.add(subjectAddition);
                });
            }
            resu.addAll(subjectAdditionsEn5Res);
        }



        List<String> enterprise = resu.stream().map(SubjectAddition::getAdditionRelationId).distinct().collect(Collectors.toList());

        Map<String, Object> enterpriseParam = getEnterpriseParam(subject, enterprise);

        String post = caiJiCenterHttpService.subjectEnterpriseSource(enterpriseParam);

        JSONObject entries = JSONUtil.parseObj(post);
        //获取code状态码
        Integer code = entries.getInt("code");
        if (ObjectUtil.isEmpty(code) ||  code != 200) {
            log.error("专题企业来源配置通知采集失败{}",post);
            throw new RuntimeException("专题企业来源配置通知采集失败");
        }
        log.info("{}专题企业来源配置通知采集结束",subject.getSubjectName());
    }


    //获取专题绑定的所有信息源id
    public List<String> getAllInfoSourceIds(String subjectId) {
        if (StrUtil.isBlank(subjectId)) {
            return new ArrayList<>();
        }

        return getBindIds(subjectId);
    }



    private List<String> getExcludeIds(String subjectId) {
        //查询排除的信息源id
        List<String> excludeIds = new ArrayList<>();

        List<SubjectInfoSourceMap> excludeInfoSource = iSubjectInfoSourceMapService.list(Wrappers.<SubjectInfoSourceMap>lambdaQuery()
                .select(SubjectInfoSourceMap::getSourceId)
                .eq(SubjectInfoSourceMap::getSubjectId, subjectId)
                .eq(SubjectInfoSourceMap::getType, BindTypeEnum.EXCLUDE_INFO_SOURCE.getvalue())
        );
        if (excludeInfoSource != null && excludeInfoSource.size() > 0) {
            excludeIds.addAll(excludeInfoSource.stream().map(SubjectInfoSourceMap::getSourceId).collect(Collectors.toList()));
        }
        //查询排除的标签信息源id
        List<SubjectInfoSourceMap> excludeInfoSourceLabel = iSubjectInfoSourceMapService.list(Wrappers.<SubjectInfoSourceMap>lambdaQuery()
                .select(SubjectInfoSourceMap::getSourceId,SubjectInfoSourceMap::getSourceItemId)
                .eq(SubjectInfoSourceMap::getSubjectId, subjectId)
                .eq(SubjectInfoSourceMap::getType, BindTypeEnum.EXCLUDE_INFO_SOURCE_LABEL.getvalue())
        );
        Set<String> labelCode = new HashSet<>();
        Set<String> labelItemCode = new HashSet<>();

        if (excludeInfoSourceLabel!= null && excludeInfoSourceLabel.size() > 0) {
            excludeInfoSourceLabel.forEach(e -> {
                labelCode.add(e.getSourceId());
                labelItemCode.add(e.getSourceItemId());
            });
            List<ClbLabelInfoSourceMap> list = clbLabelInfoSourceMapService.list(Wrappers.<ClbLabelInfoSourceMap>lambdaQuery()
                    .in(ClbLabelInfoSourceMap::getLabelCode,labelCode)
                    .in(ClbLabelInfoSourceMap::getLabelItemCode,labelItemCode)
            );
            if (CollectionUtil.isNotEmpty(list)){
                List<String> infoSourceCodes = list.stream().map(ClbLabelInfoSourceMap::getEntityCode).distinct().collect(Collectors.toList());
                List<InfoSource> list1 = iInfoSourceService.list(Wrappers.<InfoSource>lambdaQuery().select(InfoSource::getId).in(InfoSource::getId, infoSourceCodes));
                if (CollectionUtil.isNotEmpty(list1)){
                    List<String> collect = list1.stream().map(InfoSource::getId).collect(Collectors.toList());
                    excludeIds.addAll(collect);
                }
            }

        }

        //查询排除的信息源组下的所有信息源id
        List<SubjectInfoSourceMap> excludeInfoSourceGroup = iSubjectInfoSourceMapService.list(Wrappers.<SubjectInfoSourceMap>lambdaQuery()
                .select(SubjectInfoSourceMap::getSourceId)
                .eq(SubjectInfoSourceMap::getSubjectId, subjectId)
                .eq(SubjectInfoSourceMap::getType, BindTypeEnum.EXCLUDE_INFO_SOURCE_GROUP.getvalue())
        );

        if (excludeInfoSourceGroup!= null && excludeInfoSourceGroup.size() > 0) {
            List<String> groupIds = excludeInfoSourceGroup.stream().map(SubjectInfoSourceMap::getSourceId).collect(Collectors.toList());
            List<String> groupInfoSourceIds = infoSourceService.listByGroupIds(groupIds);
            excludeIds.addAll(groupInfoSourceIds);
        }
        return excludeIds;
    }

    private List<String> getBindIds(String subjectId) {
        return subjectAdditionMapper.getSubjectBindInfoSourceIds(subjectId);
    }


    private String getparam(Subject subject,Integer option,List<String> infoSourceIds) {
        Map<String,Object> param = new HashMap<>();
        param.put("subjectSign",subject.getId());
        param.put("subjectName",subject.getSubjectName());
        param.put("customerSign",caiJiCenterHttpService.getProjectCode());
        param.put("customerName",caiJiCenterHttpService.getProjectName());
        if (ObjectUtil.isNotNull(subject.getTimeEnable())) {
            param.put("startTime", DateUtil.format(subject.getTimeEnable(),"yyyy-MM-dd HH:mm:ss"));
        }else {
            param.put("startTime",DateUtil.format(getPreviousMonths(LocalDateTime.now(),6),"yyyy-MM-dd HH:mm:ss"));
        }
        if (ObjectUtil.isNotNull(subject.getTimeDisable())) {
            param.put("endTime",DateUtil.format(subject.getTimeDisable(),"yyyy-MM-dd HH:mm:ss"));
        }
        param.put("mode",option);
        param.put("infoSourceIds",infoSourceIds);
        return JSONUtil.toJsonStr(param);

    }
    private  Map<String,Object> getEnterpriseParam(Subject subject, List<String> enterprise) {
        Map<String,Object> param = new HashMap<>();
        param.put("subjectSign",subject.getId());
        param.put("subjectName",subject.getSubjectName());
        param.put("customerSign",caiJiCenterHttpService.getProjectCode());
        param.put("customerName",caiJiCenterHttpService.getProjectName());
        param.put("additionDataType",subject.getAdditionDataType());
        param.put("attentions",enterprise);
        if (ObjectUtil.isNotNull(subject.getTimeEnable())) {
            param.put("startTime", DateUtil.format(subject.getTimeEnable(),"yyyy-MM-dd HH:mm:ss"));
        }else {
            param.put("startTime",DateUtil.format(getPreviousMonths(LocalDateTime.now(),6),"yyyy-MM-dd HH:mm:ss"));
        }
        if (ObjectUtil.isNotNull(subject.getTimeDisable())) {
            param.put("endTime",DateUtil.format(subject.getTimeDisable(),"yyyy-MM-dd HH:mm:ss"));
        }
        return param;
    }

    private String getKeyWordsParam(Subject subject ,Integer option,List<KeyWords> keyWords,Integer type) {
        Map<String,Object> param = new HashMap<>();
        List<Map<String,Object>> kw = new ArrayList<>();
        param.put("subjectSign",subject.getId());
        param.put("subjectName",subject.getSubjectName());
        param.put("customerSign",caiJiCenterHttpService.getProjectCode());
        param.put("customerName",caiJiCenterHttpService.getProjectName());
        param.put("mode",option);
        param.put("type",type);
        if (ObjectUtil.isNotNull(subject.getTimeEnable())) {
            param.put("startTime", DateUtil.format(subject.getTimeEnable(),"yyyy-MM-dd HH:mm:ss"));
        }else {
            param.put("startTime",DateUtil.format(getPreviousMonths(LocalDateTime.now(),6),"yyyy-MM-dd HH:mm:ss"));
        }
        if (ObjectUtil.isNotNull(subject.getTimeDisable())) {
            param.put("endTime",DateUtil.format(subject.getTimeDisable(),"yyyy-MM-dd HH:mm:ss"));
        }
        keyWords.forEach(e -> {
            Map<String,Object> map = new HashMap<>();
            map.put("collectWordExp",e.getKeyWord());
            map.put("keywordSign",e.getId());
//            if (ObjectUtil.isNotEmpty(subject.getTimeEnable())) {
//                map.put("beginDate",DateUtil.format(subject.getTimeEnable(),"yyyy-MM-dd HH:mm:ss"));
//            }else {
//                map.put("beginDate",DateUtil.format(getPreviousMonths(LocalDateTime.now(),6),"yyyy-MM-dd HH:mm:ss"));
//            }
//            if (ObjectUtil.isNotNull(subject.getTimeDisable())) {
//                map.put("endDate",DateUtil.format(subject.getTimeDisable(),"yyyy-MM-dd HH:mm:ss"));
//            }
            kw.add(map);
        });
        param.put("keywordList",kw);
        if (type != null && type == 1) {
            LambdaQueryWrapper<ExternalSubjectInfoSourceMap> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(ExternalSubjectInfoSourceMap::getSubjectId, subject.getId())
                    .eq(ExternalSubjectInfoSourceMap::getType, 1);
            List<ExternalSubjectInfoSourceMap> sourceList = externalSubjectInfoSourceMapService.list(queryWrapper);
            param.put("sourceList",sourceList);
        }
        return JSONUtil.toJsonStr(param);

    }
    private String getEventKeyWordsParam(Event event ,Integer option,List<KeyWords> keyWords) {
        Map<String,Object> param = new HashMap<>();
        List<Map<String,Object>> kw = new ArrayList<>();
        param.put("subjectSign",event.getId());
        param.put("subjectName",event.getEventName());
        param.put("customerSign",caiJiCenterHttpService.getProjectCode()+"_event");
        param.put("customerName",caiJiCenterHttpService.getProjectName()+"_event");
        param.put("mode",option);
        if (ObjectUtil.isNotNull(event.getStartTime())) {
            param.put("startTime", DateUtil.format(event.getStartTime(),"yyyy-MM-dd HH:mm:ss"));
        }else {
            param.put("startTime",DateUtil.format(getPreviousMonths(LocalDateTime.now(),6),"yyyy-MM-dd HH:mm:ss"));
        }
        if (ObjectUtil.isNotNull(event.getEndTime())) {
            param.put("endTime",DateUtil.format(event.getEndTime(),"yyyy-MM-dd HH:mm:ss"));
        }
        keyWords.forEach(e -> {
            Map<String,Object> map = new HashMap<>();
            map.put("collectWordExp",e.getKeyWord());
            map.put("keywordSign",e.getId());

            kw.add(map);
        });
        param.put("keywordList",kw);
        return JSONUtil.toJsonStr(param);

    }
    public void subjectPolicySourceSync(String subjectId){
        Subject subject = subjectService.getSubjectOrEventById(subjectId);
        if (subject == null || subject.getStatus() == null || subject.getStatus() != 1) {
            log.info("未查询到专题或专题未启用");
            return;
        }
        try {
            remoteModelService.delSubjectCache(subjectId);
        } catch (Exception e) {
            log.error("删除专题缓存失败{}",e.getMessage(),e);
        }
        List<SubjectAddition> resu = new ArrayList<>();

        //获取专题配置的政策来源
        List<SubjectAddition> subjectAdditionsPolicy = subjectAdditionMapper.selectList(Wrappers.<SubjectAddition>lambdaQuery()
                .eq(SubjectAddition::getSubjectId, subject.getId())
                .eq(SubjectAddition::getAdditionType, 3));

        if (CollectionUtil.isNotEmpty(subjectAdditionsPolicy)) {
            resu.addAll(subjectAdditionsPolicy);
        }


        List<String> labelIds = resu.stream().map(SubjectAddition::getAdditionRelationId).distinct().collect(Collectors.toList());

        Map<String, Object> policyParam = getPolicyParam(subject, labelIds);

        String post = caiJiCenterHttpService.subjectPolicySource(policyParam);

        JSONObject entries = JSONUtil.parseObj(post);
        //获取code状态码
        Integer code = entries.getInt("code");
        if (ObjectUtil.isEmpty(code) ||  code != 200) {
            log.error("专题政策来源配置通知采集失败{}",post);
            throw new RuntimeException("专题政策来源配置通知采集失败");
        }
        log.info("{}专题政策来源配置通知采集结束",subject.getSubjectName());
    }

    private  Map<String,Object> getPolicyParam(Subject subject, List<String> labelIds) {
        Map<String,Object> param = new HashMap<>();
        param.put("subjectSign",subject.getId());
        param.put("subjectName",subject.getSubjectName());
        param.put("customerSign",caiJiCenterHttpService.getProjectCode());
        param.put("customerName",caiJiCenterHttpService.getProjectName());
//        param.put("additionDataType",subject.getAdditionDataType());
        param.put("organs",labelIds);
        if (ObjectUtil.isNotNull(subject.getTimeEnable())) {
            param.put("startTime", DateUtil.format(subject.getTimeEnable(),"yyyy-MM-dd HH:mm:ss"));
        }else {
            param.put("startTime",DateUtil.format(getPreviousMonths(LocalDateTime.now(),6),"yyyy-MM-dd HH:mm:ss"));
        }
        if (ObjectUtil.isNotNull(subject.getTimeDisable())) {
            param.put("endTime",DateUtil.format(subject.getTimeDisable(),"yyyy-MM-dd HH:mm:ss"));
        }
        return param;
    }

    //日期往前推 num 个月
    public static LocalDateTime getPreviousMonths(LocalDateTime date , int num) {
        return date.minusMonths(num);
    }
    //日期往前推 num 天
    public static LocalDateTime getPreviousDay(LocalDateTime date,int num) {
        return date.minusDays(num);
    }
    //日期往前推 num 年
    public static LocalDateTime getPreviousYear(LocalDateTime date,long num) {
        return date.minusYears(num);
    }
}
