package com.zzsn.event.entity.arrange;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 流程编排
 * @Author: jeecg-boot
 * @Date:   2024-11-14
 * @Version: V1.0
 */
@Data
@TableName("clb_model_arrange")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="clb_model_arrange对象", description="流程编排")
public class ClbModelArrange implements Serializable {
    
	/**主键id*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键id")
	private String id;
	/**分组id*/
	@Excel(name = "分组id", width = 15)
    @ApiModelProperty(value = "分组id")
	private String groupId;
	/**流程名*/
	@Excel(name = "流程名", width = 15)
    @ApiModelProperty(value = "流程名")
	private String name;
	/**流程编码*/
	@Excel(name = "流程编码", width = 15)
    @ApiModelProperty(value = "流程编码")
	private String code;
	/**流程编码*/
	@Excel(name = "流程编排信息", width = 15)
    @ApiModelProperty(value = "流程编排信息")
	private String conf;
	/**状态*/
	@Excel(name = "状态", width = 15)
    @ApiModelProperty(value = "状态")
	private Integer status;
	/**0:正常 1:删除*/
	@TableLogic
	@Excel(name = "0:正常 1:删除", width = 15)
    @ApiModelProperty(value = "0:正常 1:删除")
	private Integer delFlag;
	/**创建人*/
	@Excel(name = "创建人", width = 15)
    @ApiModelProperty(value = "创建人")
	private String createBy;
	/**创建日期*/
	@Excel(name = "创建日期", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
	private Date createTime;
	/**更新人*/
	@Excel(name = "更新人", width = 15)
    @ApiModelProperty(value = "更新人")
	private String updateBy;
	/**更新日期*/
	@Excel(name = "更新日期", width = 20, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
	private Date updateTime;
	@TableField(exist = false)
	private String subjectId;
	/**流程编码*/
	@Excel(name = "数据来源分类", width = 15)
	@ApiModelProperty(value = "数据来源分类")
	@TableField(exist = false)
	private String type;
}
