package com.zzsn.event.service;

import com.zzsn.event.entity.Subject;
import com.zzsn.event.vo.*;

import java.util.List;

/**
 * 简化专题创建流程
 *
 * @author lkg
 * @date 2025/1/9
 */
public interface SubjectSimpleService {

    /**
     * 新增专题
     *
     * @param subjectSimpleVO 参数
     * @author lkg
     * @date 2025/1/14
     */
    Subject createSubject(SubjectSimpleVO subjectSimpleVO);

    /**
     * 新增专题-对外【自定义专题地址】
     *
     * @param subjectSimpleVO 参数
     * @author lkg
     * @date 2025/1/14
     */
    Subject createExternalSubject(SubjectSimpleVO subjectSimpleVO);

    /**
     * 专题配置校验
     *
     * @param subjectParamsCheckVO 参数
     * @author lkg
     * @date 2025/2/5
     */
    Boolean configVerification(SubjectParamsCheckVO subjectParamsCheckVO);

    /**
     * 编辑专题
     *
     * @param subjectSimpleVO 参数
     * @author lkg
     * @date 2025/1/14
     */
    void editSubject(SubjectSimpleVO subjectSimpleVO);

    /**
     * 编辑专题
     *
     * @param subjectSimpleVO 参数
     * @author lkg
     * @date 2025/1/14
     */
    void editExternalSubject(SubjectSimpleVO subjectSimpleVO);

    /**
     * 专题绑定关键词信息
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/1/14
     */
    List<SearchWordVO> subjectBindWordInfo(String subjectId);

    /**
     * 专题详情(包含样例文章以及关键词)
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/1/14
     */
    SubjectDetailVO queryInfo(String subjectId);

    /**
     * 删除专题
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/1/14
     */
    void removeSubject(String subjectId);

    /**
     * 批量添加至精选
     *
     * @param searchCondition 检索条件
     * @author lkg
     * @date 2025/1/14
     */
    void selected(InfoDataSearchCondition searchCondition);

    /**
     * 批量移除精选
     *
     * @param searchCondition 检索条件
     * @author lkg
     * @date 2025/1/14
     */
    void removeSelected(InfoDataSearchCondition searchCondition);

    /**
     * 批量删除
     *
     * @param searchCondition 检索条件
     * @author lkg
     * @date 2025/1/14
     */
    void batchRemove(InfoDataSearchCondition searchCondition);

    /**
     * 清空专题数据
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/2/6
     */
    void clearSubjectData(String subjectId);
}
