package com.zzsn.event.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.*;
import com.zzsn.event.enums.BindTypeEnum;
import com.zzsn.event.enums.CodePrefixEnum;
import com.zzsn.event.mapper.InfoSourceMainGroupMapper;
import com.zzsn.event.service.*;
import com.zzsn.event.util.CodeGenerateUtil;
import com.zzsn.event.vo.InfoSourceGroupPage;
import com.zzsn.event.vo.InfoSourceMainGroupPage;
import com.zzsn.event.vo.InfoSourceVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description: 信息源组表
 * @Author: jeecg-boot
 * @Date: 2021-11-25
 * @Version: V1.0
 */
@Service
public class InfoSourceGroupMainServiceImpl extends ServiceImpl<InfoSourceMainGroupMapper, InfoSourceMainGroup> implements InfoSourceMainGroupService {

    @Autowired
    @Lazy
    private IGroupMainTypeService groupMainTypeService;
    @Autowired
    private IGroupMainTypeMapService groupMainTypeMapService;
    @Autowired
    private IInfoSourceMainGroupMapService infoSourceMainGroupMapService;
    @Autowired
    private ISubjectInfoSourceMapService iSubjectInfoSourceMapService;
    @Autowired
    private InfoSourceMainService infoSourceMainService;
    @Autowired
    private CodeGenerateUtil codeGenerateUtil;
    @Override
    public List<InfoSourceMainGroupPage> listByTypeId(List<String> list, int status) {

        return baseMapper.listByTypeId(list, status);
    }

    @Override
    public Integer countListByTypeAndIdList(List<String> oneInList, String status) {
        return baseMapper.countListByTypeAndIdList(oneInList, status);
    }

    @Override
    public IPage<InfoSourceMainGroupPage> pageByTypeId(InfoSourceMainGroup infoSourceMainGroup, Integer pageNo, Integer pageSize, String groupTypeId) {

        int offset = (pageNo - 1) * pageSize;
        //查询类别id的所有明细id
        List<String> typeIds = new ArrayList<>();
        if (!StringUtils.isEmpty(groupTypeId) && !"0".equals(groupTypeId)) {
            //查询分类id的所有的叶子节点id
            List<GroupMainType> list = groupMainTypeService.list(Wrappers.<GroupMainType>lambdaQuery().like(GroupMainType::getPathIds, groupTypeId)
                    .and(e -> e.isNull(GroupMainType::getHasChild).or().eq(GroupMainType::getHasChild, "0")));

            typeIds = list.stream().map(GroupMainType::getId).collect(Collectors.toList());
        }
        //查询列表
        List<InfoSourceMainGroupPage> pageList = baseMapper.pageList(infoSourceMainGroup, typeIds, offset, pageSize);
        if (CollectionUtil.isEmpty(pageList)) {
            return new Page<>(pageNo, pageSize, 0);
        }
        List<String> idList = pageList.stream().map(InfoSourceMainGroupPage::getId).collect(Collectors.toList());
        List<InfoSourceMainGroupPage> numberList = baseMapper.countList(idList);
        Map<String, InfoSourceMainGroupPage> countMap = numberList.stream().collect(Collectors.toMap(InfoSourceMainGroupPage::getId, item -> item));
        for (InfoSourceMainGroupPage infoSourceGroupPage : pageList) {
            InfoSourceMainGroupPage infoSourceGroupPageCount = countMap.get(infoSourceGroupPage.getId());
            if (null != infoSourceGroupPageCount) {
                infoSourceGroupPage.setInfoSourceNum(infoSourceGroupPageCount.getInfoSourceNum());
            }

            if (!StringUtils.isEmpty(infoSourceGroupPage.getTypeIds())) {
                infoSourceGroupPage.setGroupTypeIds(Arrays.asList(infoSourceGroupPage.getTypeIds().split(",")));
            }
        }

        //获取总条数
        Integer count = baseMapper.totalCount(infoSourceMainGroup, typeIds);
        IPage<InfoSourceMainGroupPage> pageData = new Page<>(pageNo, pageSize, count);
        pageData.setRecords(pageList);
        return pageData;

    }

    @Override
    public InfoSourceMainGroupPage getGroupById(String id) {
        InfoSourceMainGroupPage infoSourceMainGroupPage = baseMapper.selectGroupById(id);
        List<InfoSourceMainGroupPage> numberList = baseMapper.countList(Arrays.asList(id));
        if (CollectionUtil.isNotEmpty(numberList)) {
            infoSourceMainGroupPage.setInfoSourceNum(numberList.get(0).getInfoSourceNum());
        }
        return infoSourceMainGroupPage;
    }

    @Override
    public void deleteMain(String groupId) {
        super.removeById(groupId);

        //删除与类别的映射
        groupMainTypeMapService.remove(Wrappers.<GroupMainTypeMap>lambdaQuery().eq(GroupMainTypeMap::getGroupId, groupId));
        //删除信息源组与专题的绑定关系
        List<String> infoSourceGroupIds = new ArrayList<>();
        infoSourceGroupIds.add(groupId);
        iSubjectInfoSourceMapService.deleteInfoSourceIds(null, infoSourceGroupIds, BindTypeEnum.INFO_MAIN_SOURCE_GROUP.getvalue());
        //删除信息源与专题的绑定关系
        List<String> idsList = baseMapper.selectInfoSourceByGroupIds(infoSourceGroupIds);
        if (idsList != null && idsList.size() > 0) {
            iSubjectInfoSourceMapService.deleteInfoSourceIds(null, idsList, BindTypeEnum.INFO_MAIN_SOURCE.getvalue());
        }
        //删除信息源组与信息源的绑定关系
        infoSourceMainGroupMapService.remove(Wrappers.<InfoSourceMainGroupMap>lambdaQuery().eq(InfoSourceMainGroupMap::getGroupId, groupId));
    }

    @Override
    public void deleteMainByIds(List<String> list) {
        super.removeByIds(list);
        //删除与类别的映射
        groupMainTypeMapService.remove(Wrappers.<GroupMainTypeMap>lambdaQuery().in(GroupMainTypeMap::getGroupId, list));
        //删除信息源组与专题的绑定关系
        List<String> infoSourceGroupIds = new ArrayList<>();
        infoSourceGroupIds.addAll(list);
        iSubjectInfoSourceMapService.deleteInfoSourceIds(null, infoSourceGroupIds, BindTypeEnum.INFO_MAIN_SOURCE_GROUP.getvalue());
        //删除信息源与专题的绑定关系
        List<String> idsList = baseMapper.selectInfoSourceByGroupIds(infoSourceGroupIds);
        if (idsList != null && idsList.size() > 0) {
            iSubjectInfoSourceMapService.deleteInfoSourceIds(null, idsList, BindTypeEnum.INFO_MAIN_SOURCE.getvalue());
        }
        //删除信息源组与信息源的绑定关系
        infoSourceMainGroupMapService.remove(Wrappers.<InfoSourceMainGroupMap>lambdaQuery().in(InfoSourceMainGroupMap::getGroupId, list));
    }

    @Override
    public List<InfoSourceVo> bindListByGroupIds(List<String> list) {

        return baseMapper.bindListByGroupIds(list);
    }

    @Override
    public void updateMain(InfoSourceMainGroup infoSourceGroup, List<String> groupTypeIds) {
        super.updateById(infoSourceGroup);

        //删除信息源组-信息员组类别绑定关系
        groupMainTypeMapService.remove(Wrappers.<GroupMainTypeMap>lambdaQuery().eq(GroupMainTypeMap::getGroupId, infoSourceGroup.getId()));
        //插入新的
        saveMapMain(infoSourceGroup, groupTypeIds);
    }

    @Override
    public void saveMain(InfoSourceMainGroup infoSourceGroup, List<String> groupTypeIds) {
        String groupCode = codeGenerateUtil.geneCodeNo(CodePrefixEnum.INFO_SOURCE_MAIN_GROUP_DEFAULT.getValue());
        infoSourceGroup.setGroupCode(groupCode);
        super.save(infoSourceGroup);
        //插入信息源组-类别的绑定关系
        saveMapMain(infoSourceGroup, groupTypeIds);
    }

    @Override
    public List<InfoSourceMainGroupPage> listByTypeIdList(List<String> groupTypeIdList, String subjectId, int status, String keywords) {
        //在根据所有明细节点查出专题列表
        return baseMapper.listByTypeIdList( groupTypeIdList, subjectId, status,keywords);
    }

    /**
     * 根据分类id获取信息源列表(ynBind=0 :查询没有绑定该组的信息源列表  ynBind=1 :查询绑定该组的信息源列表 )
     */
    @Override
    public IPage<InfoSourceVo> pageListByGroupId(InfoSourceVo infoSourceVo, Integer ynBind, String groupId, Integer pageNo, Integer pageSize) {
        int offset = (pageNo - 1) * pageSize;
        //查询列表
        List<InfoSourceVo> pageList = baseMapper.pageListByGroupId(infoSourceVo, ynBind, groupId, offset, pageSize);
        //获取总条数
        Integer count = baseMapper.totalCountByGroupId(infoSourceVo, ynBind, groupId);
        IPage<InfoSourceVo> pageData = new Page<>(pageNo, pageSize, count);
        pageData.setRecords(pageList);
        return pageData;
    }

    @Override
    public String bind(String groupId, List<String> sourceIds) {

        String message = "绑定成功！";
        if(!StringUtils.isEmpty(groupId) && sourceIds != null && sourceIds.size() > 0){

            List<InfoSourceMainGroupMap> list = infoSourceMainGroupMapService.list(Wrappers.<InfoSourceMainGroupMap>lambdaQuery()
                    .eq(InfoSourceMainGroupMap::getGroupId, groupId)
                    .in(InfoSourceMainGroupMap::getSourceId, sourceIds));
            if (CollectionUtil.isEmpty(list)) {
                sourceIds.forEach(item -> {
                    InfoSourceMainGroupMap infoSourceGroupMap = new InfoSourceMainGroupMap();
                    infoSourceGroupMap.setGroupId(groupId);
                    infoSourceGroupMap.setSourceId(item);
                    infoSourceMainGroupMapService.save(infoSourceGroupMap);
                });
            }else{
                message = "部分已经绑定信息源成功过滤，未绑定的信息源已经绑定！";
                List<String> bindSourceIds = list.stream().map(InfoSourceMainGroupMap::getSourceId).collect(Collectors.toList());
                sourceIds.removeAll(bindSourceIds);
                if (sourceIds.size() > 0) {
                    sourceIds.forEach(item -> {
                        InfoSourceMainGroupMap infoSourceGroupMap = new InfoSourceMainGroupMap();
                        infoSourceGroupMap.setGroupId(groupId);
                        infoSourceGroupMap.setSourceId(item);
                        infoSourceMainGroupMapService.save(infoSourceGroupMap);
                    });
                }
            }

        }
        return message;
    }

    @Override
    public void unBind(String groupId, List<String> sourceIds) {
        if(!StringUtils.isEmpty(groupId) && sourceIds != null && sourceIds.size() > 0){
            infoSourceMainGroupMapService.remove(Wrappers.<InfoSourceMainGroupMap>lambdaQuery()
                    .eq(InfoSourceMainGroupMap::getGroupId, groupId)
                    .in(InfoSourceMainGroupMap::getSourceId, sourceIds));
        }
    }

    @Override
    public IPage<InfoSourceMain> infosourceMainList(InfoSourceMain infoSourceMain, Integer pageNo, Integer pageSize) {
        Page<InfoSourceMain> page = new Page<>(pageNo, pageSize);
        Page<InfoSourceMain> page1 = infoSourceMainService.page(page, Wrappers.<InfoSourceMain>lambdaQuery()
                .like(StrUtil.isNotBlank(infoSourceMain.getInfoName()),InfoSourceMain::getInfoName, infoSourceMain.getInfoName())
                .eq(StrUtil.isNotBlank(infoSourceMain.getInfoAddress()),InfoSourceMain::getInfoAddress, infoSourceMain.getInfoAddress())
                .eq(StrUtil.isNotBlank(infoSourceMain.getCode()),InfoSourceMain::getCode, infoSourceMain.getCode())
                .eq(ObjectUtil.isNotEmpty(infoSourceMain.getType()),InfoSourceMain::getType, infoSourceMain.getType())
                .orderByDesc(InfoSourceMain::getCreateTime));
        return page1;
    }

    @Override
    public List<InfoSourceMainGroupPage> bindInfoSourceMainGroupList(String subjectId, List<Integer> types) {
        return baseMapper.bindInfoSourceMainGroupList(subjectId, types);
    }

    @Override
    public List<InfoSourceMain> bindInfoSourceMainList(String subjectId, List<Integer> types) {
        return baseMapper.bindInfoSourceMainList(subjectId, types);
    }

    @Override
    public List<InfoSourceMainGroupPage> bindInfoSourceMainLabelList(String subjectId, List<Integer> types) {
        return baseMapper.bindInfoSourceMainLabelList(subjectId, types);
    }

    private void saveMapMain(InfoSourceMainGroup infoSourceGroup, List<String> TypeIds) {
        if (!StringUtils.isEmpty(TypeIds)) {
            for (String TypeId : TypeIds) {
                GroupMainTypeMap groupTypeMap = new GroupMainTypeMap();
                groupTypeMap.setGroupId(infoSourceGroup.getId());
                groupTypeMap.setCreateBy(infoSourceGroup.getCreateBy());
                groupTypeMap.setCreateTime(infoSourceGroup.getCreateTime());
                groupTypeMap.setUpdateBy(infoSourceGroup.getUpdateBy());
                groupTypeMap.setUpdateTime(infoSourceGroup.getUpdateTime());
                groupTypeMap.setSysOrgCode(infoSourceGroup.getSysOrgCode());
                groupTypeMap.setTypeId(TypeId);
                groupMainTypeMapService.save(groupTypeMap);
            }
        }

    }


}
