package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

/**
 * 克虏宝中的事件标签数据库，因为python目前只更新克虏宝事件标签库，所以这里直接取克虏宝的事件标签库
 * @Description: EventTag
 * @Author: jeecg-boot
 * @Date:   2024-03-14
 * @Version: V1.0
 */
@Data
@TableName("event_tag")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value="EventTag对象", description="事件")
public class EventTagClb {
    
	/**ID*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "ID")
	private String id;

	private String eventId;
	private String extractIndustryTag;
	private String extractCompanyTag;
	private String extractPersonTag;
	private String extractSentimentTag;
	private String extractKeywordsTag;
	private String extractLocationTag;
	private String extractTimeTag;
}
