package com.zzsn.event.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.InfoSourceMain;
import com.zzsn.event.entity.InfoSourceMainGroup;
import com.zzsn.event.vo.InfoSourceGroupPage;
import com.zzsn.event.vo.InfoSourceMainGroupPage;
import com.zzsn.event.vo.InfoSourceVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 信息源组表
 * @Author: jeecg-boot
 * @Date: 2021-11-25
 * @Version: V1.0
 */
public interface InfoSourceMainGroupService extends IService<InfoSourceMainGroup> {

    List<InfoSourceMainGroupPage> listByTypeId(List<String> list, int status);

    Integer countListByTypeAndIdList(List<String> oneInList, String status);

    IPage<InfoSourceMainGroupPage> pageByTypeId(InfoSourceMainGroup infoSourceMainGroup, Integer pageNo, Integer pageSize, String groupTypeId);

    InfoSourceMainGroupPage getGroupById(String id);

    void deleteMain(String id);

    void deleteMainByIds(List<String> list);

    List<InfoSourceVo> bindListByGroupIds(List<String> list);

    void updateMain(InfoSourceMainGroup infoSourceGroup, List<String> groupTypeIds);

    void saveMain(InfoSourceMainGroup infoSourceGroup, List<String> groupTypeIds);

    List<InfoSourceMainGroupPage> listByTypeIdList(List<String> groupTypeIdList, String subjectId, int status, String keywords);

    IPage<InfoSourceVo> pageListByGroupId(InfoSourceVo infoSourceVo, Integer ynBind, String groupId, Integer pageNo, Integer pageSize);

    String bind(String groupId, List<String> infoSourceIds);

    void unBind(String groupId, List<String> infoSourceIds);

    IPage<InfoSourceMain> infosourceMainList(InfoSourceMain infoSourceVo, Integer pageNo, Integer pageSize);

    List<InfoSourceMainGroupPage> bindInfoSourceMainGroupList(String subjectId, List<Integer> typeIds);

    List<InfoSourceMain> bindInfoSourceMainList( String subjectId, List<Integer> typeIds);

    List<InfoSourceMainGroupPage> bindInfoSourceMainLabelList(String subjectId, List<Integer> infoSourceMainLabelType);
}
