package com.zzsn.event.controller.reportData;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zzsn.event.vo.es.Label;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

@Data
public class SearchCondition {

    //专题id
    @FieldDescription(value = "专题id")
    private String subjectId;

    //搜索范围(all、title、content、origin)
    @FieldDescription(value = "搜索范围")
    private String searchScope = "title";
    //搜索词
    @FieldDescription(value = "搜索词")
    private String searchWord;

    //开始时间
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    //结束时间

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    //专题库类型(对应字典编码为【Thematic_Library】的数据字典值)
    @FieldDescription(value = "专题库类型")
    private List<Integer> classificationType;

    /**原创性(0-非原创;1-原创;2-疑似)*/
    @FieldDescription(value = "原创性")
    private String originality;

    //审核状态(1-通过;2-未审核;3-暂定;4-删除;5-免审核)
    @FieldDescription(value = "审核状态")
    private Integer status;

    //审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0)
    private Integer checkStatus;
    //删除标记(1:删除；0:未删除)
    private Integer deleteFlag = 0;
    //是否免审核(1-是;0-否)
    private Integer isFreeCheck;

    //爬虫类型
    @FieldDescription(value = "爬虫类型")
    private String crawler;

    //组合标签查询(不同类标签之间是与的关系，同一类标签之间是或的关系)，示例: "a,b;c,d;e,f"
    @FieldDescription(value = "组合标签查询")
    private String composeSearchLabelIds;

    /**----企业类标签筛选----**/
    //企业类标签id集合
    @FieldDescription(value = "企业类标签id集合")
    private List<String> enterpriseLabelTypeIds;
    //企业信用代码集合
    @FieldDescription(value = "企业信用代码集合")
    private List<String> socialCreditCodeList;
    /**----企业类标签id集合----**/
    //专题关联标签值id集合
    @FieldDescription(value = "专题关联标签值id集合")
    private List<String> labelIds;
    //正负面标签
    @FieldDescription(value = "正负面标签")
    private String tendencyLabelId;
    //地域标签id集合
    @FieldDescription(value = "地域标签id集合")
    private List<String> areaLabelIds;
    //专题关联信息源标签集合
    private List<Label> infoSourceLabelList;

    //得分范围-研究中心
    //最小得分
    @FieldDescription(value = "最小得分")
    private Integer minScore;
    //最大得分
    @FieldDescription(value = "最大得分")
    private Integer maxScore;

    //es查询字段数组
    @FieldDescription(value = "查询字段数组")
    private String[] fetchFields;
    //排除字段数组
    @FieldDescription(value = "排除字段数组")
    private String[] excludeFields = new String[]{"content", "contentWithTag"};

    //排序参数
    //排序字段
    @FieldDescription(value = "排序字段")
    private String column = "publishDate";
    //排序方式 asc/desc
    @FieldDescription(value = "排序方式")
    private String order = "desc";
    //置顶排序是否起效(1-是;0-否)
    @FieldDescription(value = "置顶排序是否起效")
    private Integer topSortValid = 0;

    //分页参数
    //当前页
    @FieldDescription(value = "当前页")
    private Integer pageNo = 1;
    //每页返回条数
    @FieldDescription(value = "每页返回条数")
    private Integer pageSize = 10;
}
