package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 信息源表
 * @Author: jeecg-boot
 * @Date:   2021-10-15
 * @Version: V1.0
 */
@ApiModel(value="info_source对象", description="信息源表")
@Data
@TableName("info_source")
public class InfoSource implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**信息源编码*/
    @ApiModelProperty(value = "信息源编码")
    private String infoSourceCode;
	/**信息源名称*/
    @ApiModelProperty(value = "信息源名称")
    private String webSiteName;
	/**栏目名称*/
    @ApiModelProperty(value = "栏目名称")
    private String siteName;
	/**栏目地址*/
    @ApiModelProperty(value = "栏目地址")
    private String siteUri;
	/**网站重要级别*/
    @ApiModelProperty(value = "网站重要级别")
    private String siteLevel;
	/**国家*/
    @ApiModelProperty(value = "国家")
    private String country;
	/**是否境外*/
    @ApiModelProperty(value = "是否境外")
    private String ynOther;
	/**地区*/
    @ApiModelProperty(value = "地区")
    private String area;
	/**是否需要登录*/
    @ApiModelProperty(value = "是否需要登录")
    private Integer ynLogin;
	/**语种*/
    @ApiModelProperty(value = "语种")
    private String language;
	/**是否公共*/
    @ApiModelProperty(value = "是否公共")
    private String ynPublic;
	/**是否需要翻墙*/
    @ApiModelProperty(value = "是否需要翻墙")
    private Integer ynAbroad;
	/**是否需要代理*/
    @ApiModelProperty(value = "是否需要代理")
    private Integer ynAgent;
	/**动态爬取*/
    @ApiModelProperty(value = "动态爬取")
    private Integer ynBrowser;
	/**调度时间间隔*/
    @ApiModelProperty(value = "调度时间间隔")
    private String period;
	/**调度周期（cron自动生成）*/
    @ApiModelProperty(value = "调度周期（cron自动生成）")
    private String cron;
	/**调度周期说明*/
    @ApiModelProperty(value = "调度周期说明")
    private String remarkCron;
	/**信息源状态*/
    @ApiModelProperty(value = "信息源状态")
    private Integer status;
	/**网站可信度*/
    @ApiModelProperty(value = "网站可信度")
    private Integer siteReliability;
	/**信息源综合评分*/
    @ApiModelProperty(value = "信息源综合评分")
    private Integer score;
	/**爬取深度*/
    @ApiModelProperty(value = "爬取深度")
    private Integer crawlDepth;
	/**爬取方式*/
    @ApiModelProperty(value = "爬取方式")
    private Integer crawlType;
	/**历史数据URL*/
    @ApiModelProperty(value = "历史数据URL")
    private String hisUriExp;
	/**历史数据开始时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "历史数据开始时间")
    private Date hisDateStarttime;
	/**历史数据结束时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "历史数据结束时间")
    private Date hisDateEndtime;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private String sysOrgCode;
    /**验证结果*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String verification;
    /**验证失败原因*/
    private String verificationFailureCause;

    /**所属单位*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String company;
    /**所属行业*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String industry;
    /**权威性*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String authority;
    /**可信度*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String reliability;
    /**原创度*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String originality;
    /**父网站*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String parentSite;
    /**是否保存快照（1：保存   0：不保存）*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String ynSnapshot;
    /**是否启动原创性校验（1：启动   0：不启动）*/
    private String ynVerification;
    /**原创来源（中文逗号隔开）*/
    private String originalSource;
}
