package com.zzsn.event.controller.yjzx;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.SubjectAnalysis;
import com.zzsn.event.service.SubjectAnalysisService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 事件相关分析维护
 *
 * @author lkg
 * @date 2024/5/11
 */
@RestController
@RequestMapping("/maintenance")
public class EventMaintenanceController {

    @Autowired
    private SubjectAnalysisService subjectAnalysisService;

    /**
     * 专题事件脉络列表
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2024/5/27
     */
    @GetMapping("/eventContextList")
    public Result<?> eventContextList(@RequestParam String subjectId){
        LambdaQueryWrapper<SubjectAnalysis> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectAnalysis::getSubjectId, subjectId).eq(SubjectAnalysis::getCategory, 2)
                .orderByAsc(SubjectAnalysis::getPublishDate);
        List<SubjectAnalysis> list = subjectAnalysisService.list(queryWrapper);
        return Result.OK(list);
    }

    /**
     * 事件脉络编辑
     *
     * @param subjectAnalysis 事件脉络信息
     * @author lkg
     * @date 2024/5/11
     */
    @PostMapping("/eventContextModify")
    public Result<?> eventContextModify(@RequestBody SubjectAnalysis subjectAnalysis){
        subjectAnalysisService.eventContextModify(subjectAnalysis);
        return Result.OK();
    }

    /**
     * 删除事件脉络
     *
     * @param id 主键id
     * @author lkg
     * @date 2024/5/27
     */
    @GetMapping("/eventContextRemove")
    public Result<?> eventContextRemove(String id){
        subjectAnalysisService.removeById(id);
        return Result.OK();
    }
}
