package com.zzsn.event.mapper;

import com.zzsn.event.entity.EventContext;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
* @author lenovo
* @description 针对表【event_context(事件脉络表)】的数据库操作Mapper
* @createDate 2025-07-14 18:05:06
* @Entity com.zzsn.event.entity.EventContext
*/
@Mapper
public interface EventContextMapper extends BaseMapper<EventContext> {

    /**
     * 获取事件下最大的排序号
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2025/7/14
     */
    @Select("SELECT IFNULL(MAX(sort_number), 1) FROM event_context WHERE event_id = #{eventId}")
    Integer getMaxSortNumber(@Param("eventId") String eventId);

}




