package com.zzsn.event.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.List;

@Data
public class InfoSourceGroupPage {
    /**
     * 主键
     */
    private String id;
    /**
     * 组编码
     */
    private String groupCode;
    /**
     * 信息源组名称
     */
    private String groupName;

    /**
     * 绑定信息源组的信息源ids
     */
    private List<String> infoSourceIds;

    /**
     * 组类别id
     */
    private List<String> groupTypeIds;

    private String typeIds;
    private String typeId;

    /**
     * 组类别名称
     */
    private String groupTypeNames;

    /**
     * 分组说明
     */
    private String groupRemark;
    /**
     * 状态
     */
    private Integer status;
    /**
     * 创建人
     */
    private String createBy;
    /**
     * 创建日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private java.util.Date createTime;
    /**
     * 更新人
     */
    private String updateBy;
    /**
     * 更新日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private java.util.Date updateTime;
    /**
     * 所属部门
     */
    private String sysOrgCode;

    /**
     * 信息源类别
     */
    private Integer sourceType;

    /**
     * 信息源权重（以组设置）
     */
    private String weight;

    /**
     * 专题绑定信息源的主键id
     */
    private String subjectInfoSourceId;
    private Integer infoSourceNum;

    private String groupTypeId;
    private String subjectId;
    /**
     * 是否免过关键词  0否   1是
     */
    private Integer isExemptKeyword;
    /**
     * 是否免审核 0否  1是
     */
    private Integer isFreeCheck;
}
