package com.zzsn.event.vo.log;

import cn.hutool.core.net.NetUtil;
import lombok.Getter;
import lombok.Setter;

/**
 * 持有类为数据生命周期日志{@link DataLifecycleLog}
 * 此类记录发送日志方服务器信息
 *
 * @author 张宗涵
 * @date 2024/4/25
 */
@Getter
@Setter
public class Server {
    /**
     * 服务器名称
     */
    private String serverHostName;

    /**
     * 服务器ip
     */
    private String serverIp;

    /**
     * 进程id
     */
    private String processId;

    /**
     * 获取服务器信息
     *
     * @return
     */
    public static Server getServer() {
        Server server = new Server();
        server.setServerIp(NetUtil.getLocalhost().getHostAddress());
        server.setServerHostName(NetUtil.getLocalhost().getHostName());
        server.setProcessId(String.valueOf(Thread.currentThread().getId()));
        return server;
    }
}
