package com.zzsn.event.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.entity.*;
import com.zzsn.event.enums.KeyWordsTypeEnum;
import com.zzsn.event.enums.ModelTypeEnum;
import com.zzsn.event.enums.ScoreTypeEnum;
import com.zzsn.event.feign.entity.SysDict;
import com.zzsn.event.mapper.CommonMapper;
import com.zzsn.event.service.*;
import com.zzsn.event.util.DateUtil;
import com.zzsn.event.util.ObsUtil;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.util.user.AuthUtil;
import com.zzsn.event.vo.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.*;

/**
 * 公用服务
 *
 * @author lkg
 * @date 2024/12/17
 */
@Service
public class CommonServiceImpl implements CommonService {
    @Autowired
    private CommonMapper commonMapper;

    @Autowired
    private ScoreModelService scoreModelService;
    @Autowired
    private IEventService eventService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private ISubjectModelMapService subjectModelMapService;
    @Autowired
    private SubjectKeywordsService subjectKeywordsService;
    @Autowired
    private ObsUtil obsUtil;


    @Override
    public List<Node> columnList(List<String> columnIds) {
        return commonMapper.columnList(columnIds);
    }

    @Override
    public List<Node> projectList() {
        return commonMapper.projectList(AuthUtil.getAuthUserId());
    }

    @Override
    public List<String> codesByLabels(List<String> labelIds) {
        return commonMapper.codesByLabels(labelIds);
    }

    @Override
    public JSONObject siteInfo(String subjectId, String type, Integer category) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("subjectId", subjectId);
        //增加该专题绑定的关键词
        List<String> keyWordsIds = new ArrayList<>();
        List<String> saveType = new ArrayList<>();
        List<String> groupList = new ArrayList<>();
        List<HashMap<String, String>> tommonModel = new ArrayList<>();
        List<HashMap<String, String>> keyWordModel = new ArrayList<>();
        List<HashMap<String, String>> scoreModel = new ArrayList<>();
        String library = null;
        Date startTime = null;
        Date endTime = null;
        if (category == 1) {
            Subject subject = subjectService.getById(subjectId);
            library = subject.getLibrary();
            startTime = subject.getTimeEnable();
            endTime = subject.getTimeDisable();
        } else if (category == 2) {
            Event event = eventService.getById(subjectId);
            startTime = event.getStartTime();
            endTime = event.getEndTime();
        }
        //若是单独更改，则传单个的打分模型参数部分，其它的模块不需要
        if (StringUtils.isEmpty(type)) {
            //关键词
            List<KeyWordsPage> keyWordsPages = commonMapper.selectKeyWordsListById(subjectId);
            for (KeyWordsPage keyWordsPage : keyWordsPages) {
                keyWordsIds.add(keyWordsPage.getId());
            }

            if (!StringUtils.isEmpty(library)) {
                String[] list = library.split(",");
                for (String value : list) {
                    if ("1".equals(value)) {
                        saveType.add("Policy");
                    } else if ("2".equals(value)) {
                        saveType.add("LeaderSpeech");
                    } else if ("3".equals(value)) {
                        saveType.add("ExpertOpinion");
                    } else if ("4".equals(value)) {
                        saveType.add("BusinessCase");
                    } else if ("5".equals(value)) {
                        saveType.add("EnterpriseData");
                    } else if ("6".equals(value)) {
                        saveType.add("ResearchReport");
                    } else if ("7".equals(value)) {
                        saveType.add("HowNetPapers");
                    }
                }
            }
            //查询绑定的信息源组
            List<InfoSourceGroupPage> list = commonMapper.selectInfoSourceListById(subjectId);
            for (InfoSourceGroupPage infoSourceGroupPage : list) {
                groupList.add(infoSourceGroupPage.getId());
            }
            //查询去重、筛选、标签模型
            List<SubjectModelMap> mapList = subjectModelMapService.selectModelBySubjectId(subjectId);
            for (SubjectModelMap subjectModelMap : mapList) {
                HashMap<String, String> map = new HashMap<>();
                map.put("modelId", subjectModelMap.getModelId());
                map.put("modelName", subjectModelMap.getModelName());
                if (ModelTypeEnum.REMOVE_MODEL.getValue().equals(subjectModelMap.getType())) {
                    map.put("type", "DeduplicationModels");
                } else if (ModelTypeEnum.CHOSE_MODEL.getValue().equals(subjectModelMap.getType())) {
                    map.put("type", "FilterModels");
                } else if (ModelTypeEnum.LABEL_MODEL.getValue().equals(subjectModelMap.getType())) {
                    map.put("type", "TagModels");
                }
                tommonModel.add(map);
            }

            //查询关键词模型
            LambdaQueryWrapper<SubjectKeywords> query = Wrappers.lambdaQuery();
            query.eq(SubjectKeywords::getSubjectId, subjectId);
            List<SubjectKeywords> keywordsList = subjectKeywordsService.list(query);
            for (SubjectKeywords subjectKeywords : keywordsList) {
                HashMap<String, String> map = new HashMap<>();
                map.put("keyWordsId", subjectKeywords.getId());
                if (KeyWordsTypeEnum.VIEWPOINT_MODEL.getvalue().equals(subjectKeywords.getType())) {
                    map.put("type", "ExpertOpinionKeyWord");
                } else if (KeyWordsTypeEnum.CASE_KEYWORDS_MODEL.getvalue().equals(subjectKeywords.getType())) {
                    map.put("type", "PolicyKeyWord");
                } else if (KeyWordsTypeEnum.LEADER_SPEECH_MODEL.getvalue().equals(subjectKeywords.getType())) {
                    map.put("type", "BusinessCaseKeyWord");
                } else if (KeyWordsTypeEnum.POLICY_KEYWORDS_MODEL.getvalue().equals(subjectKeywords.getType())) {
                    map.put("type", "LeaderSpeechKeyWord");
                } else if (KeyWordsTypeEnum.ENTERPRISE_DATA_KEYWORDS_MODEL.getvalue().equals(subjectKeywords.getType())) {
                    map.put("type", "EnterpriseDataKeyWord");
                } else if (KeyWordsTypeEnum.RESEARCH_REPORT_KEYWORDS_MODEL.getvalue().equals(subjectKeywords.getType())) {
                    map.put("type", "ResearchReportKeyWord");
                } else if (KeyWordsTypeEnum.HOWNET_PAPERS_KEYWORDS_MODEL.getvalue().equals(subjectKeywords.getType())) {
                    map.put("type", "HowNetPapersKeyWord");
                }
                map.put("keyWord", subjectKeywords.getKeyWord());
                map.put("exclusionWord", subjectKeywords.getExclusionWord());
                keyWordModel.add(map);
            }

            //查询打分模型
            LambdaQueryWrapper<ScoreModel> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(ScoreModel::getSubjectId, subjectId);
            List<ScoreModel> modelList = scoreModelService.list(queryWrapper);
            for (ScoreModel scoreModel1 : modelList) {
                HashMap<String, String> map = new HashMap<>();
                map.put("scoreId", scoreModel1.getId());
                if (ScoreTypeEnum.COMMON_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "GeneralScoreModel");
                } else if (ScoreTypeEnum.VIEWPOINT_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "ExpertOpinionScoreModel");
                } else if (ScoreTypeEnum.CASE_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "BusinessCaseScoreModel");
                } else if (ScoreTypeEnum.POLICY_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "PolicyScoreModel");
                } else if (ScoreTypeEnum.LEADER_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "LeaderSpeechScoreModel");
                } else if (ScoreTypeEnum.ENTERPRISE_DATA_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "EnterpriseDataScoreModel");
                } else if (ScoreTypeEnum.RESEARCH_REPORT_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "ResearchReportScoreModel");
                } else if (ScoreTypeEnum.HOWNET_PAPERS_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "HowNetPapersScoreModel");
                }
                map.put("data", scoreModel1.getData().toString());
                scoreModel.add(map);
            }
        } else {
            //查询打分模型
            List<ScoreModelVo> modelList = scoreModelService.queryScoreModel(subjectId, type);
            for (ScoreModelVo scoremodelVO : modelList) {
                ScoreModel scoreModel1 = new ScoreModel();
                BeanUtils.copyProperties(scoremodelVO, scoreModel1);
                HashMap<String, String> map = new HashMap<>();
                map.put("scoreId", scoreModel1.getId());
                if (ScoreTypeEnum.COMMON_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "GeneralScoreModel");
                } else if (ScoreTypeEnum.VIEWPOINT_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "ExpertOpinionScoreModel");
                } else if (ScoreTypeEnum.CASE_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "BusinessCaseScoreModel");
                } else if (ScoreTypeEnum.POLICY_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "PolicyScoreModel");
                } else if (ScoreTypeEnum.LEADER_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "LeaderSpeechScoreModel");
                } else if (ScoreTypeEnum.ENTERPRISE_DATA_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "EnterpriseDataScoreModel");
                } else if (ScoreTypeEnum.RESEARCH_REPORT_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "ResearchReportScoreModel");
                } else if (ScoreTypeEnum.HOWNET_PAPERS_SCORE_MODEL.getvalue().equals(scoreModel1.getType())) {
                    map.put("type", "HowNetPapersScoreModel");
                }
                map.put("data", scoreModel1.getData().toString());
                scoreModel.add(map);
            }
        }

        if (startTime != null) {
            jsonObject.put("startTime", DateUtil.dateToString(startTime));
        } else {
            jsonObject.put("startTime", "");
        }
        if (endTime != null) {
            jsonObject.put("endTime", DateUtil.dateToString(endTime));
        } else {
            jsonObject.put("endTime", "");
        }
        jsonObject.put("keyWordsIds", keyWordsIds);
        jsonObject.put("SubjectClassificationType", saveType);
        jsonObject.put("InfoSourceGroupList", groupList);
        jsonObject.put("Models", tommonModel);
        jsonObject.put("KeyWordModels", keyWordModel);
        jsonObject.put("ScoreModels", scoreModel);
        return jsonObject;
    }

    @Override
    public List<KeyWordsPage> selectKeyWordsListById(String subjectId) {
        return commonMapper.selectKeyWordsListById(subjectId);
    }

    @Override
    public List<SubjectPage> bindKeyWordsCountList(List<String> idList) {
        return commonMapper.bindKeyWordsCountList(idList);
    }

    @Override
    public List<SubjectSourceVO> bindSourceList(List<String> subjectIds) {
        List<SubjectSourceVO> bindList = commonMapper.bindSourceList(subjectIds);
        List<SubjectSourceVO> excludeList = commonMapper.excludeSourceList(subjectIds);
        bindList.removeAll(excludeList);
        return bindList;
    }

    @Override
    public List<ModelVO> allList(String subjectType) {
        List<ModelVO> allList = new ArrayList<>();
        List<ModelVO> list = commonMapper.modelList();
        List<ModelVO> typeList = getTreeList(list);
        ModelVO modelVO = new ModelVO();
        modelVO.setId("0");
        modelVO.setModelName("模型");
        modelVO.setPid("0");
        modelVO.setHasChild("1");
        modelVO.setChildren(typeList);
        //拼接三个节点
        ModelVO modelVO1 = new ModelVO();
        modelVO1.setId("1");
        modelVO1.setModelName("基本信息");
        allList.add(modelVO1);
        ModelVO modelVO2 = new ModelVO();
        modelVO2.setId("2");
        modelVO2.setModelName("数据配置");
        allList.add(modelVO2);
        ModelVO modelVO3 = new ModelVO();
        modelVO3.setId("3");
        modelVO3.setModelName("关键词组");
        allList.add(modelVO3);
        ModelVO modelVO4 = new ModelVO();
        modelVO4.setId("4");
        modelVO4.setModelName("搜索引擎");
        allList.add(modelVO4);
        ModelVO modelVO5 = new ModelVO();
        modelVO5.setId("5");
        modelVO5.setModelName("数据资源");
        allList.add(modelVO5);
        if ("1".equals(subjectType)) {
            allList.add(modelVO);
        }
        return allList;
    }

    @Override
    public List<LabelModelVo> subjectModelBindLabels(List<String> subjectIds) {
        return commonMapper.subjectModelBindLabels(subjectIds);
    }

    @Override
    public Set<String> getExcludeKeywords(String databaseIds) {
        Set<String> set = new HashSet<>();
        if(databaseIds == null){
            databaseIds = "";
        }
        List<String> keywords = commonMapper.getExcludeKeywords(Arrays.asList(databaseIds.split(",")));
        if(CollectionUtils.isNotEmpty(keywords)){
            set.addAll(keywords);
        }
        return set;
    }

    @Override
    public void downloadTemplate(HttpServletResponse response, String path) {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        byte[] bytes = obsUtil.getObjectByte(path);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            OutputStream outs = response.getOutputStream();
            bos = new BufferedOutputStream(outs);
            bis = new BufferedInputStream(inputStream);
            int i;
            while ((i = bis.read(bytes)) != -1) {
                bos.write(bytes, 0, i);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                bos.flush();
                bos.close();
                bis.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<LabelItemMapVO> infoSourceLabelsBySidList(List<String> sidList) {
        List<LabelItemMapVO> clbLabelItems = new ArrayList<>();
        if (CollectionUtils.isEmpty(sidList)) {
            clbLabelItems = commonMapper.infoSourceLabelsBySidList(sidList);
        }
        return clbLabelItems;
    }

    @Override
    public Map<String, Integer> bindSourceCount(List<String> subjectIds) {
        Map<String, Integer> map = new HashMap<>();
        List<SubjectSourceVO> bindList = commonMapper.bindSourceCount(subjectIds);
        if (CollectionUtils.isNotEmpty(bindList)) {
            for (SubjectSourceVO subjectSourceVO : bindList) {
                map.put(subjectSourceVO.getSubjectId(), subjectSourceVO.getCount());
            }
        }
        return map;
    }

    @Override
    public List<SysDict> selectOldLabelTypeList() {
        return commonMapper.selectOldLabelTypeList();
    }

    @Override
    public List<SysDict> selectLeaderTypeList() {
        return commonMapper.selectLeaderTypeList();
    }

    //获取树状结构
    private List<ModelVO> getTreeList(List<ModelVO> authTypeList){
        List<ModelVO> topList = new ArrayList<>();
        authTypeList.forEach(e->{
            if ("0".equals(e.getPid())) {
                topList.add(e);
            }
        });
        for (ModelVO model : topList) {
            setChildren(model, authTypeList);
        }
        //排序
        topList.sort(Comparator.comparingInt(ModelVO::getOrderNo));
        for(ModelVO modelVo : topList){
            if(modelVo.getChildren() != null && modelVo.getChildren().size() > 0){
                sort(modelVo);
            }
        }
        return topList;
    }

    //排序
    private void sort(ModelVO modelVo) {
        modelVo.getChildren().sort(Comparator.comparingInt(ModelVO::getOrderNo));
        modelVo.setChildren(modelVo.getChildren());
        for (ModelVO modelVo1 : modelVo.getChildren()) {
            if (modelVo1.getChildren() != null && modelVo1.getChildren().size() > 0) {
                sort(modelVo1);
            }
        }
    }
    //递归获取树形结构数据
    private void setChildren(ModelVO parent, List<ModelVO> list) {
        Set<ModelVO> children = getChildren(list, parent.getId());
        parent.setChildren(new ArrayList<>(children));
        for (ModelVO model : children) {
            setChildren(model, list);
        }
    }
    private Set<ModelVO> getChildren(List<ModelVO> list, String id) {
        Set<ModelVO> children = new HashSet<>();
        for (ModelVO model : list) {
            if (model.getPid().equals(id)) {
                children.add(model);
            }
        }
        return children;
    }

}
