package com.zzsn.event.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 数据生命周期 数据处理异常类型枚举
 * @author 张宗涵
 * @date 2024/4/26
 */
@Getter
@AllArgsConstructor
public enum EnumExceptionType {
    UNKNOWN("未知"),
    PROGRAM("程序异常"),
    DATA("数据异常");

    private final String value;

    @JsonValue
    @Override
    public String toString() {
        return ordinal() + ":" + value;
    }
}
