package com.zzsn.event.service;

import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.ClbFileOperationLog;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.util.user.UserVo;
import com.zzsn.event.vo.*;
import com.zzsn.event.vo.es.DisplayInfo;
import com.zzsn.event.vo.es.SpecialInformation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 资讯
 *
 * @author lkg
 * @date 2024/12/19
 */
public interface InformationService {

    /**
     * 采集库资讯分页列表
     *
     * @param eventDataCondition 资讯类查询条件
     * @author lkg
     * @date 2024/5/6
     */
    IPage<EventDataVO> collectPageList(InfoDataSearchCondition eventDataCondition);

    /**
     * 专题库资讯分页列表
     *
     * @param subjectInfo 筛选条件
     * @author lkg
     * @date 2024/5/6
     */
    IPage<DisplayInfo> subjectPageList(InfoDataSearchCondition subjectInfo);

    /**
     * 专题库资讯分页列表
     *
     * @param subjectInfo 筛选条件
     * @author lkg
     * @date 2024/5/6
     */
    IPage<SpecialInformation> subjectPageListForDataDetail(InfoDataSearchCondition subjectInfo);

    /**
     * 资讯分页列表（根据标签分类分组）
     */
    Result subjectPageListGroupByLabel(UserVo userVo, InfoDataSearchCondition subjectInfo);

    /**
     * 保存数据集-研究中心
     *
     * @param searchCondition 筛选条件
     * @author lkg
     * @date 2025/1/6
     */
    void saveAsDataSet(InfoDataSearchCondition searchCondition);

    /**
     * 批量删除标签
     *
     * @param searchCondition 筛选条件
     * @author lkg
     * @date 2025/4/10
     */
    void removeLabels(InfoDataSearchCondition searchCondition);

    /**
     * 资讯详情
     *
     * @param type  类别(1-采集库;2-专题库)
     * @param index es索引
     * @param id    资讯id
     * @author lkg
     * @date 2024/12/19
     */
    DisplayInfo queryInfo(Integer type, String index, String id);

    /**
     * 专题资讯统计导出信息集合
     *
     * @param subjectId 专题/专题分类id
     * @param startDate 开始时间
     * @param endDate   结束时间
     * @author lkg
     * @date 2024/12/19
     */
    List<List<String>> statisticsExportList(String subjectId, String startDate, String endDate);


    /**
     * 人工添加(采集库到专题库)
     *
     * @param manualAddVOs 参数
     * @author lkg
     * @date 2024/12/19
     */
    void manualAdd(List<ManualAddVO> manualAddVOs);

    /**
     * 判断资讯是否存在
     *
     * @param displayInfo 资讯参数
     * @author lkg
     * @date 2024/12/19
     */
    boolean duplicationByTitleOrSourceAddress(DisplayInfo displayInfo);

    /**
     * 新增
     *
     * @param displayInfo 参数
     * @param category    类别(1-专题;2-事件)
     * @param userVo      当前用户信息
     * @author lkg
     * @date 2024/12/19
     */
    void add(DisplayInfo displayInfo, Integer category, UserVo userVo);

    /**
     * 编辑
     *
     * @param jsonObject 参数
     * @param userVo     当前用户信息
     * @author lkg
     * @date 2024/12/19
     */
    void updateInfo(JSONObject jsonObject, UserVo userVo);

    /**
     * 资讯绑定标签
     *
     * @param dataBindLabelFrom 绑定参数
     * @param boundList         专题绑定的标签(数据字典)集合
     * @author lkg
     * @date 2025/3/31
     */
    void modifyLabel(DataBindLabelFrom dataBindLabelFrom, List<DictVO> boundList);

    /**
     * 审核
     *
     * @param map    审核参数
     * @param userVo 当前用户信息
     * @author lkg
     * @date 2024/12/19
     */
    void checkInfo(Map<String, Object> map, UserVo userVo);

    /**
     * 批量删除-专题库(逻辑删除)
     *
     * @param map    删除参数
     * @param userVo 当前用户信息
     * @author lkg
     * @date 2024/12/19
     */
    void deleteBatch(Map<String, Object> map, UserVo userVo);

    /**
     * 批量删除-采集库(物理删除)
     *
     * @param map 删除参数
     * @author lkg
     * @date 2024/12/19
     */
    void removeBatch(Map<String, Object> map);

    /**
     * 置顶
     *
     * @param subjectInfoVo 参数
     * @param userVo        当前用户信息
     * @author lkg
     * @date 2024/12/19
     */
    void topInfo(SubjectInfoVo subjectInfoVo, UserVo userVo);

    /**
     * 置顶
     *
     * @param collectionInfo 收藏信息
     * @author lkg
     * @date 2024/12/19
     */
    void collect(CollectionInfo collectionInfo);

    /**
     * 热词
     *
     * @param index  es索引
     * @param id     资讯id
     * @param number 热词数量
     * @author lkg
     * @date 2024/12/19
     */
    List<StatisticsKeyWordVo> hotWords(String index, String id, Integer number);

    /**
     * 推荐列表
     *
     * @param subjectId 专题id
     * @param id        资讯id
     * @param title     资讯标题
     * @param pageNo    当前页
     * @param pageSize  每页返回条数
     * @author lkg
     * @date 2024/12/19
     */
    List<SubjectDataVo> recommendList(String subjectId, String id, String title, Integer pageNo, Integer pageSize);

    /**
     * 批量导入数据到发布库
     *
     * @author lkg
     * @date 2025/2/5
     */
    void importInfo(List<List<String>> lists, String subjectId, String isTopping, String isExamine, ClbFileOperationLog clbFileOperationLog, UserVo userVo);

    /**
     * 批量导入数据到发布库-研究中心
     *
     * @author lkg
     * @date 2025/2/5
     */
    void importDataInfo(List<FileDataVO> lists, String subjectId);

    /**
     * 移除专题下的数据-研究中心
     *
     * @param subjectId 专题id
     * @param themeIds  删除主题(关联标签)id集合
     * @author lkg
     * @date 2025/2/20
     */
    void removeByCondition(String subjectId, List<String> themeIds);

    /**
     * 新增专题下的数据-研究中心
     *
     * @param subjectId 专题id
     * @param themeIds  新增主题(关联标签)id集合
     * @author lkg
     * @date 2025/2/20
     */
    void supplyByCondition(String subjectId, List<String> themeIds);

    /**
     * 获取所有资讯列表
     *
     * @param searchCondition 检索条件
     * @author lkg
     * @date 2025/2/28
     */
    List<SpecialInformation> informationAllList(InfoDataSearchCondition searchCondition);
}
