package com.zzsn.event.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.entity.*;
import com.zzsn.event.enums.BindTypeEnum;
import com.zzsn.event.service.*;
import com.zzsn.event.vo.KeyWordsPage;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class ConfigurationMessageService {


    public static enum MessageType {

        INFOSOURCE_GROUP("INFOSOURCE_GROUP","信息源组"),
        INFOSOURCE("INFOSOURCE","信息源"),
        INFOSOURCE_LABEL("INFOSOURCE_LABEL","信息源标签"),
        ;

        public List<MessageType> getAll (){
            return  Arrays.asList(MessageType.values());
        }

        public String getCode() {
            return code;
        }

        public String getName() {
            return name;
        }

        MessageType(String code, String name) {
            this.code = code;
            this.name = name;
        }

        /**服务编码*/
        private final String code;
        /**服务名*/
        private final String name;
    }



    public static enum OptionType {


        BIND("BIND","绑定",0),
        UNBIND("UNBIND","解绑",1),
        ;

        public List<OptionType> getAll (){
            return  Arrays.asList(OptionType.values());
        }

        public String getCode() {
            return code;
        }

        public String getName() {
            return name;
        }
        public Integer getValue() {
            return value;
        }

        OptionType(String code, String name,Integer value) {
            this.code = code;
            this.name = name;
            this.value = value;
        }

        /**编码*/
        private final String code;
        /**名称*/
        private final String name;
        /**值*/
        private final Integer value;
    }

    @Autowired
    private IInfoSourceService infoSourceService;
    @Autowired
    private InfoSourceGroupService infoSourceGroupService;
    @Autowired
    private ISubjectInfoSourceMapService iSubjectInfoSourceMapService;
    @Autowired
    private SubjectService subjectService;
    @Autowired
    private IInfoSourceService iInfoSourceService;

    @Autowired
    private IKeyWordsService keyWordsService;

    @Autowired
    ClbLabelInfoSourceMapService clbLabelInfoSourceMapService;

    @Value("${caiji.infosourcebind.url:http://1.95.79.85:8823/baseSourceInfo/api/subject/infoSourceEdit}")
    private String infosourcebindUrl;
    @Value("${caiji.keyWordsbind.url:http://1.95.79.85:8823/baseSourceInfo/api/subject/keywordEdit}")
    private String keyWordsbindUrl;
    @Value("${caiji.keyWordsEdit.url:http://1.95.79.85:8823/baseSourceInfo/api/keyword/edit}")
    private String keyWordsEditUrl;
    @Value("${caiji.projectCode:zzsn}")
    private String projectCode;
    @Value("${caiji.projectName:克虏宝}")
    private String projectName;




    /**
    * 绑定解绑信息源
    * option 绑定，解绑
    * idsType 绑定或者解绑的类型
    *
    * */
    public void sendConfigurationMessage(String subjectId, List<String> ids,String option,String idsType) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        Subject byId = subjectService.getById(subjectId);
        if (byId == null) {
            return;
        }
        if (OptionType.BIND.getCode().equals(option)) {
            //绑定
            if (MessageType.INFOSOURCE_GROUP.getCode().equals(idsType)) {
                //绑定信息源组
                List<String> infoSourceIds = infoSourceService.listByGroupIds(ids);

                List<String> excludeIds = getExcludeIds(subjectId);


                if (CollectionUtil.isNotEmpty(excludeIds)) {
                    infoSourceIds.removeAll(excludeIds);
                }
                if (infoSourceIds!= null && infoSourceIds.size() > 0) {
                    HttpUtil.post(infosourcebindUrl,getparam(byId, OptionType.BIND.getValue(),infoSourceIds));
                }

            } else if (MessageType.INFOSOURCE.getCode().equals(idsType)) {
                //绑定信息源

                List<String> excludeIds = getExcludeIds(subjectId);


                if (CollectionUtil.isNotEmpty(excludeIds)) {
                    ids.removeAll(excludeIds);
                }
                if (ids!= null && ids.size() > 0) {
                    HttpUtil.post(infosourcebindUrl,getparam(byId, OptionType.BIND.getValue(),ids));
                }
            } else if (MessageType.INFOSOURCE_LABEL.getCode().equals(idsType)) {
                //绑定信息源标签
                List<String> excludeIds = getExcludeIds(subjectId);

                if (CollectionUtil.isNotEmpty(excludeIds)) {
                    ids.removeAll(excludeIds);
                }

                if (ids!= null && ids.size() > 0) {
                    HttpUtil.post(infosourcebindUrl,getparam(byId, OptionType.BIND.getValue(),ids));
                }
            }
        } else if (OptionType.UNBIND.getCode().equals(option)) {
            //解绑
            if (MessageType.INFOSOURCE_GROUP.getCode().equals(idsType)) {
                //解绑信息源组
                List<String> bindIds = getBindIds(subjectId);
                List<String> infoSourceIds = infoSourceService.listByGroupIds(ids);
                if (infoSourceIds!= null && infoSourceIds.size() > 0) {
                    if (CollectionUtil.isNotEmpty(bindIds)) {
                        infoSourceIds.removeAll(bindIds);
                    }
                    if (CollectionUtil.isNotEmpty(infoSourceIds)) {
                        HttpUtil.post(infosourcebindUrl,getparam(byId, OptionType.UNBIND.getValue(),infoSourceIds));
                    }
                }
            } else if (MessageType.INFOSOURCE.getCode().equals(idsType)) {
                //解绑信息源
                if (ids!= null && ids.size() > 0) {
                    List<String> bindIds = getBindIds(subjectId);
                    if (CollectionUtil.isNotEmpty(bindIds)) {
                        ids.removeAll(bindIds);
                    }
                    HttpUtil.post(infosourcebindUrl,getparam(byId, OptionType.UNBIND.getValue(),ids));
                }
            } else if (MessageType.INFOSOURCE_LABEL.getCode().equals(idsType)) {
                //解绑信息源标签
                List<String> bindIds = getBindIds(subjectId);
                if (CollectionUtil.isNotEmpty(bindIds)) {
                    ids.removeAll(bindIds);
                }
                if (ids!= null && ids.size() > 0) {
                    HttpUtil.post(infosourcebindUrl,getparam(byId, OptionType.UNBIND.getValue(),ids));
                }
            }
        }


    }

    public void sendConfigurationMessage(String subjectId,List<String> old,List<String> now,String option) {
        Subject byId = subjectService.getById(subjectId);
        if (byId == null) {
            return;
        }
        if (OptionType.UNBIND.getCode().equals(option)) {
            if (CollectionUtil.isEmpty(old)) {
                return;
            }
            old.removeAll(now);
            if (CollectionUtil.isNotEmpty(old)) {
                String getparam = getparam(byId, OptionType.UNBIND.getValue(), old);
                log.info("解绑信息源通知采集{}",getparam);

                String post = HttpUtil.post(infosourcebindUrl, getparam);
                JSONObject entries = JSONUtil.parseObj(post);
                //获取code状态码
                Integer code = entries.getInt("code");
                if (ObjectUtil.isEmpty(code) ||  code != 200) {
                    log.error("解绑信息源通知采集失败{}",post);
                    throw new RuntimeException("解绑信息源通知采集失败");
                }

            }
        }else {
            List<String> bindIds = new ArrayList<>();
            if (CollectionUtil.isNotEmpty(now)) {
                bindIds.addAll(now);
            }
            if (CollectionUtil.isNotEmpty(old)) {
                bindIds.removeAll(old);
            }

            if (CollectionUtil.isNotEmpty(bindIds)) {
                String getparam = getparam(byId, OptionType.BIND.getValue(), bindIds);
                log.info("绑定信息源通知采集{}",getparam);
                String post = HttpUtil.post(infosourcebindUrl, getparam);
                JSONObject entries = JSONUtil.parseObj(post);
                //获取code状态码
                Integer code = entries.getInt("code");
                if (ObjectUtil.isEmpty(code) ||  code != 200) {
                    log.error("绑定信息源通知采集失败{}",post);
                    throw new RuntimeException("绑定信息源通知采集失败");
                }
            }
        }

    }
    public void sendKeyWordsConfigurationMessage(String subjectId, List<String> keywordsIds, String option) {
        Subject byId = subjectService.getById(subjectId);
        if (byId == null) {
            return;
        }
        if (CollectionUtil.isEmpty(keywordsIds)) {
            return;
        }
        List<KeyWords> keyWords = keyWordsService.listByIds(keywordsIds);

        if (OptionType.UNBIND.getCode().equals(option)) {
            String keyWordsParam = getKeyWordsParam(byId, OptionType.UNBIND.getValue(), keyWords);
            log.info("解绑关键词通知采集{}",keyWordsParam);

            String post = HttpUtil.post(keyWordsbindUrl, keyWordsParam);
            JSONObject entries = JSONUtil.parseObj(post);
            //获取code状态码
            Integer code = entries.getInt("code");
            if (ObjectUtil.isEmpty(code) ||  code != 200) {
                log.error("解绑关键词通知采集失败{}",post);
                throw new RuntimeException("解绑关键词通知采集失败");
            }

        }else {
            String keyWordsParam = getKeyWordsParam(byId, OptionType.BIND.getValue(), keyWords);
            log.info("绑定关键词通知采集{}",keyWordsParam);
            String post = HttpUtil.post(keyWordsbindUrl, keyWordsParam);
            JSONObject entries = JSONUtil.parseObj(post);
            //获取code状态码
            Integer code = entries.getInt("code");
            if (ObjectUtil.isEmpty(code) ||  code != 200) {
                log.error("绑定关键词通知采集失败{}",post);
                throw new RuntimeException("绑定关键词通知采集失败");
            }
        }

    }

    public void bindKeyWordsSend(String subjectId) {
        Subject byId = subjectService.getById(subjectId);
        if (byId == null) {
            log.info("未查询到专题");
            return;
        }
        List<String> subjectIdList = new ArrayList<>();
        subjectIdList.add(subjectId);
        List<KeyWordsPage> keyWordsPages = subjectService.bindKeyWordsListByIdsAndBindType(subjectIdList,"1");
        String keyWordsParam;
        if (CollectionUtil.isEmpty(keyWordsPages)) {
            log.info("专题未绑定采集词组,通知采集清空");
            keyWordsParam = getKeyWordsParam(byId, null, new ArrayList<>());
        }else {
            List<KeyWords> keyWords = keyWordsService.listByIds(keyWordsPages.stream().map(KeyWordsPage::getId).collect(Collectors.toList()));
            keyWordsParam = getKeyWordsParam(byId, null, keyWords);
        }

        log.info("专题关键词配置通知采集{}",keyWordsParam);

        String post = HttpUtil.post(keyWordsbindUrl, keyWordsParam);
        JSONObject entries = JSONUtil.parseObj(post);
        //获取code状态码
        Integer code = entries.getInt("code");
        if (ObjectUtil.isEmpty(code) ||  code != 200) {
            log.error("专题关键词配置通知采集失败{}",post);
            throw new RuntimeException("专题关键词配置通知采集失败");
        }
        log.info("{}专题关键词配置通知采集结束",byId.getSubjectName());
    }


    public void bindInfoSourceSend(String subjectId){
        Subject byId = subjectService.getById(subjectId);
        if (byId == null) {
            return;
        }

        List<String> bindIds = getAllInfoSourceIds(subjectId);

        String getparam ;
        if (CollectionUtil.isNotEmpty(bindIds)) {
            getparam = getparam(byId, null, bindIds);
        }else {
            log.info("专题未绑定信息源,通知采集清空");

            getparam = getparam(byId, null, new ArrayList<>());
        }

        log.info("专题信息源配置通知采集{}",getparam);
        String post = HttpUtil.post(infosourcebindUrl, getparam);
        JSONObject entries = JSONUtil.parseObj(post);
        //获取code状态码
        Integer code = entries.getInt("code");
        if (ObjectUtil.isEmpty(code) ||  code != 200) {
            log.error("专题信息源配置通知采集失败{}",post);
            throw new RuntimeException("专题信息源配置通知采集失败");
        }
        log.info("{}专题信息源配置通知采集结束",byId.getSubjectName());
    }


    public void sendEditKeyWordsConfigurationMessage(String keyWordId) {
        KeyWords byId = keyWordsService.getById(keyWordId);
        Map<String,Object> param = new HashMap<>();
        param.put("customerSign",projectCode);
        param.put("customerName",projectName);
        param.put("keywordSign",byId.getId());
        param.put("collectWordExp",byId.getKeyWord());
        log.info("编辑关键词通知采集{}",JSONUtil.toJsonStr(param));
        HttpUtil.post(keyWordsEditUrl,JSONUtil.toJsonStr(param));
    }

    //获取专题绑定的所有信息源id
    public List<String> getAllInfoSourceIds(String subjectId) {
        if (StrUtil.isBlank(subjectId)) {
            return new ArrayList<>();
        }
        List<String> bindIds = getBindIds(subjectId);
        List<String> excludeIds = getExcludeIds(subjectId);
        if (CollectionUtil.isNotEmpty(excludeIds)) {
            bindIds.removeAll(excludeIds);
        }
        return bindIds;
    }



    private List<String> getExcludeIds(String subjectId) {
        //查询排除的信息源id
        List<String> excludeIds = new ArrayList<>();

        List<SubjectInfoSourceMap> excludeInfoSource = iSubjectInfoSourceMapService.list(Wrappers.<SubjectInfoSourceMap>lambdaQuery()
                .select(SubjectInfoSourceMap::getSourceId)
                .eq(SubjectInfoSourceMap::getSubjectId, subjectId)
                .eq(SubjectInfoSourceMap::getType, BindTypeEnum.EXCLUDE_INFO_SOURCE.getvalue())
        );
        if (excludeInfoSource != null && excludeInfoSource.size() > 0) {
            excludeIds.addAll(excludeInfoSource.stream().map(SubjectInfoSourceMap::getSourceId).collect(Collectors.toList()));
        }
        //查询排除的标签信息源id
        List<SubjectInfoSourceMap> excludeInfoSourceLabel = iSubjectInfoSourceMapService.list(Wrappers.<SubjectInfoSourceMap>lambdaQuery()
                .select(SubjectInfoSourceMap::getSourceId)
                .select(SubjectInfoSourceMap::getSourceItemId)
                .eq(SubjectInfoSourceMap::getSubjectId, subjectId)
                .eq(SubjectInfoSourceMap::getType, BindTypeEnum.EXCLUDE_INFO_SOURCE_LABEL.getvalue())
        );
        Set<String> labelCode = new HashSet<>();
        Set<String> labelItemCode = new HashSet<>();

        if (excludeInfoSourceLabel!= null && excludeInfoSourceLabel.size() > 0) {
            excludeInfoSourceLabel.forEach(e -> {
                labelCode.add(e.getSourceId());
                labelItemCode.add(e.getSourceItemId());
            });
            List<ClbLabelInfoSourceMap> list = clbLabelInfoSourceMapService.list(Wrappers.<ClbLabelInfoSourceMap>lambdaQuery()
                    .in(ClbLabelInfoSourceMap::getLabelCode,labelCode)
                    .in(ClbLabelInfoSourceMap::getLabelItemCode,labelItemCode)
            );
            if (CollectionUtil.isNotEmpty(list)){
                List<String> infoSourceCodes = list.stream().map(ClbLabelInfoSourceMap::getEntityCode).distinct().collect(Collectors.toList());
                List<InfoSource> list1 = iInfoSourceService.list(Wrappers.<InfoSource>lambdaQuery().select(InfoSource::getId).in(InfoSource::getInfoSourceCode, infoSourceCodes));
                if (CollectionUtil.isNotEmpty(list1)){
                    List<String> collect = list1.stream().map(InfoSource::getId).collect(Collectors.toList());
                    excludeIds.addAll(collect);
                }
            }

        }

        //查询排除的信息源组下的所有信息源id
        List<SubjectInfoSourceMap> excludeInfoSourceGroup = iSubjectInfoSourceMapService.list(Wrappers.<SubjectInfoSourceMap>lambdaQuery()
                .select(SubjectInfoSourceMap::getSourceId)
                .eq(SubjectInfoSourceMap::getSubjectId, subjectId)
                .eq(SubjectInfoSourceMap::getType, BindTypeEnum.EXCLUDE_INFO_SOURCE_GROUP.getvalue())
        );

        if (excludeInfoSourceGroup!= null && excludeInfoSourceGroup.size() > 0) {
            List<String> groupIds = excludeInfoSourceGroup.stream().map(SubjectInfoSourceMap::getSourceId).collect(Collectors.toList());
            List<String> groupInfoSourceIds = infoSourceService.listByGroupIds(groupIds);
            excludeIds.addAll(groupInfoSourceIds);
        }
        return excludeIds;
    }

    private List<String> getBindIds(String subjectId) {
        //查询绑定的信息源id
        List<String> excludeIds = new ArrayList<>();
        List<SubjectInfoSourceMap> excludeInfoSource = iSubjectInfoSourceMapService.list(Wrappers.<SubjectInfoSourceMap>lambdaQuery()
                .select(SubjectInfoSourceMap::getSourceId)
                .eq(SubjectInfoSourceMap::getSubjectId, subjectId)
                .eq(SubjectInfoSourceMap::getType, BindTypeEnum.INFO_SOURCE.getvalue())
        );
        if (excludeInfoSource != null && excludeInfoSource.size() > 0) {
            excludeIds.addAll(excludeInfoSource.stream().map(SubjectInfoSourceMap::getSourceId).collect(Collectors.toList()));
        }
        //查询绑定的标签信息源id
        List<SubjectInfoSourceMap> excludeInfoSourceLabel = iSubjectInfoSourceMapService.list(Wrappers.<SubjectInfoSourceMap>lambdaQuery()
                .select(SubjectInfoSourceMap::getSourceId)
                .select(SubjectInfoSourceMap::getSourceItemId)
                .eq(SubjectInfoSourceMap::getSubjectId, subjectId)
                .in(SubjectInfoSourceMap::getType, Arrays.asList(BindTypeEnum.INFO_SOURCE_LABEL.getvalue(),BindTypeEnum.DIRECTIONA_INFO_SOURCE_LABEL.getvalue()))
        );
        Set<String> labelCode = new HashSet<>();
        Set<String> labelItemCode = new HashSet<>();

        if (excludeInfoSourceLabel!= null && excludeInfoSourceLabel.size() > 0) {
            excludeInfoSourceLabel.forEach(e -> {
                labelCode.add(e.getSourceId());
                labelItemCode.add(e.getSourceItemId());
            });
            List<ClbLabelInfoSourceMap> list = clbLabelInfoSourceMapService.list(Wrappers.<ClbLabelInfoSourceMap>lambdaQuery()
                    .in(ClbLabelInfoSourceMap::getLabelCode,labelCode)
                    .in(ClbLabelInfoSourceMap::getLabelItemCode,labelItemCode)
            );
            if (CollectionUtil.isNotEmpty(list)){
                List<String> infoSourceCodes = list.stream().map(ClbLabelInfoSourceMap::getEntityCode).distinct().collect(Collectors.toList());
                List<InfoSource> list1 = iInfoSourceService.list(Wrappers.<InfoSource>lambdaQuery().select(InfoSource::getId).in(InfoSource::getInfoSourceCode, infoSourceCodes));
                if (CollectionUtil.isNotEmpty(list1)){
                    List<String> collect = list1.stream().map(InfoSource::getId).collect(Collectors.toList());
                    excludeIds.addAll(collect);
                }
            }

        }

        //查询绑定的的信息源组下的所有信息源id
        List<SubjectInfoSourceMap> excludeInfoSourceGroup = iSubjectInfoSourceMapService.list(Wrappers.<SubjectInfoSourceMap>lambdaQuery()
                .select(SubjectInfoSourceMap::getSourceId)
                .eq(SubjectInfoSourceMap::getSubjectId, subjectId)
                .in(SubjectInfoSourceMap::getType, Arrays.asList(BindTypeEnum.INFO_SOURCE_GROUP.getvalue(),BindTypeEnum.DIRECTIONA_INFO_SOURCE_GROUP.getvalue()))
        );

        if (excludeInfoSourceGroup!= null && excludeInfoSourceGroup.size() > 0) {
            List<String> groupIds = excludeInfoSourceGroup.stream().map(SubjectInfoSourceMap::getSourceId).collect(Collectors.toList());
            List<String> groupInfoSourceIds = infoSourceService.listByGroupIds(groupIds);
            excludeIds.addAll(groupInfoSourceIds);
        }
        return excludeIds;
    }


    private String getparam(Subject subject,Integer option,List<String> infoSourceIds) {
        Map<String,Object> param = new HashMap<>();
        param.put("subjectSign",subject.getId());
        param.put("subjectName",subject.getSubjectName());
        param.put("customerSign",projectCode);
        param.put("customerName",projectName);
        if (ObjectUtil.isNotNull(subject.getTimeEnable())) {
            param.put("startTime", DateUtil.format(subject.getTimeEnable(),"yyyy-MM-dd HH:mm:ss"));
        }else {
            param.put("startTime",DateUtil.format(getPreviousMonths(LocalDateTime.now(),6),"yyyy-MM-dd HH:mm:ss"));
        }
        if (ObjectUtil.isNotNull(subject.getTimeDisable())) {
            param.put("endTime",DateUtil.format(subject.getTimeDisable(),"yyyy-MM-dd HH:mm:ss"));
        }
        param.put("mode",option);
        param.put("infoSourceIds",infoSourceIds);
        return JSONUtil.toJsonStr(param);

    }
    private String getKeyWordsParam(Subject subject ,Integer option,List<KeyWords> keyWords) {
        Map<String,Object> param = new HashMap<>();
        List<Map<String,Object>> kw = new ArrayList<>();
        param.put("subjectSign",subject.getId());
        param.put("subjectName",subject.getSubjectName());
        param.put("customerSign",projectCode);
        param.put("customerName",projectName);
        param.put("mode",option);
        if (ObjectUtil.isNotNull(subject.getTimeEnable())) {
            param.put("startTime", DateUtil.format(subject.getTimeEnable(),"yyyy-MM-dd HH:mm:ss"));
        }else {
            param.put("startTime",DateUtil.format(getPreviousMonths(LocalDateTime.now(),6),"yyyy-MM-dd HH:mm:ss"));
        }
        if (ObjectUtil.isNotNull(subject.getTimeDisable())) {
            param.put("endTime",DateUtil.format(subject.getTimeDisable(),"yyyy-MM-dd HH:mm:ss"));
        }
        keyWords.forEach(e -> {
            Map<String,Object> map = new HashMap<>();
            map.put("collectWordExp",e.getKeyWord());
            map.put("keywordSign",e.getId());
//            if (ObjectUtil.isNotEmpty(subject.getTimeEnable())) {
//                map.put("beginDate",DateUtil.format(subject.getTimeEnable(),"yyyy-MM-dd HH:mm:ss"));
//            }else {
//                map.put("beginDate",DateUtil.format(getPreviousMonths(LocalDateTime.now(),6),"yyyy-MM-dd HH:mm:ss"));
//            }
//            if (ObjectUtil.isNotNull(subject.getTimeDisable())) {
//                map.put("endDate",DateUtil.format(subject.getTimeDisable(),"yyyy-MM-dd HH:mm:ss"));
//            }
            kw.add(map);
        });
        param.put("keywordList",kw);
        return JSONUtil.toJsonStr(param);

    }

    //日期往前推 num 个月
    public static LocalDateTime getPreviousMonths(LocalDateTime date , int num) {
        return date.minusMonths(num);
    }
    //日期往前推 num 天
    public static LocalDateTime getPreviousDay(LocalDateTime date,int num) {
        return date.minusDays(num);
    }
    //日期往前推 num 年
    public static LocalDateTime getPreviousYear(LocalDateTime date,long num) {
        return date.minusYears(num);
    }
}
