package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;

/**
 * @Description: 频道表
 * @Author: jeecg-boot
 * @Date:   2022-05-11
 * @Version: V1.0
 */
@Data
@TableName("sys_base_channel")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="sys_base_channel对象", description="频道表")
public class SysBaseChannel implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**频道名称*/
	@Excel(name = "频道名称", width = 15)
    @ApiModelProperty(value = "频道名称")
    private String channelName;
	/**频道配置来源*/
	@Excel(name = "频道配置来源", width = 15)
    @ApiModelProperty(value = "频道配置来源")
    private String source;
	/**频道组id集合*/
	@Excel(name = "频道组id集合", width = 15)
    @ApiModelProperty(value = "频道组id集合")
    private String channelGroupIds;
	/**频道id集合*/
	@Excel(name = "频道id集合", width = 15)
    @ApiModelProperty(value = "频道id集合")
    private String channelIds;
	/**专题id集合*/
	@Excel(name = "专题id集合", width = 15)
    @ApiModelProperty(value = "专题id集合")
    private String subjectIds;
    private String subjectTypes;
	/**地域id集合*/
	@Excel(name = "地域id集合", width = 15)
    @ApiModelProperty(value = "地域id集合")
    private String regionIds;
    private String regionTypes;
	/**企业id集合*/
	@Excel(name = "企业id集合", width = 15)
    @ApiModelProperty(value = "企业id集合")
    private String enterpriseIds;
    private String enterpriseTypes;
	/**行业id集合*/
	@Excel(name = "行业id集合", width = 15)
    @ApiModelProperty(value = "行业id集合")
    private String industryIds;
    private String industryTypes;
	/**标签类别id集合*/
	@Excel(name = "标签类别id集合", width = 15)
    @ApiModelProperty(value = "标签类别id集合")
    private String labelIds;
	/**具体某类标签的id*/
	@Excel(name = "具体某类标签的id", width = 15)
    @ApiModelProperty(value = "具体某类标签的id")
    private String detailLabelIds;
    /**组合的json*/
    private Object json;
	/**频道类型*/
	@Excel(name = "频道类型", width = 15)
    @ApiModelProperty(value = "频道类型")
    private String displayType;
	/**说明*/
	@Excel(name = "说明", width = 15)
    @ApiModelProperty(value = "说明")
    private String explanation;
	/**排序*/
	@Excel(name = "排序", width = 15)
    @ApiModelProperty(value = "排序")
    private Integer sort;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private String sysOrgCode;
    /**所属客户*/
    @ApiModelProperty(value = "所属客户")
    private String customerId;
    /**与、或关系(and-与;or-或)*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    @ApiModelProperty(value = "与、或关系(and-与;or-或)")
    private String relation;
    /**标签类别名称*/
    @ApiModelProperty(value = "标签类别名称")
    private String labelType;
    /**标签类别标识*/
    @ApiModelProperty(value = "标签类别标识")
    private String labelMark;
    /**状态*/
    private Integer status;
    /**code编码*/
    private String code;
    @TableField(exist = false)
    private Integer type;

}
