package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author obcy
 * @since 2024-08-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName("clb_label_item")
public class ClbLabelItem extends Model<ClbLabelItem> {

    private static final long serialVersionUID = 1L;

    /**
     * 标签值id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 创建人
     */
    @TableField("create_by")
    private String createBy;

    /**
     * 创建日期
     */
    @TableField("create_time")
    private Date createTime;

    /**
     * 更新人
     */
    @TableField("update_by")
    private String updateBy;

    /**
     * 更新日期
     */
    @TableField("update_time")
    private Date updateTime;

    /**
     * 所属标签id
     */
    @TableField("label_id")
    private String labelId;

    /**
     * 标签值编码
     */
    @TableField("label_item_code")
    private String labelItemCode;

    /**
     * 标签值名称
     */
    @TableField("label_item_name")
    private String labelItemName;

    /**
     * 节点绝对路径
     */
    @TableField("path_ids")
    private String pathIds;


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

}
