package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.SubjectType;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.SubjectTreeVO;
import com.zzsn.event.vo.SubjectTypeTreeVO;
import com.zzsn.event.vo.SubjectTypeVo;

import java.util.List;

/**
 * @Description: 专题类别
 * @Author: jeecg-boot
 * @Date: 2021-12-01
 * @Version: V1.0
 */
public interface ISubjectTypeService extends IService<SubjectType> {

    /**
     * 可用的专题分类列表
     *
     * @param category 类别(1-专题;2-事件)
     * @author lkg
     * @date 2024/4/29
     */
    List<Node> enableList(Integer category);

    /**
     * 可用的专题分类列表-研究中心
     *
     * @param username 创建人
     * @author lkg
     * @date 2024/4/29
     */
    List<Node> researchCenterEnableList(String username);

    /**
     * 获取分类下的所有节点id集合
     *
     * @param typeId 分类id
     * @param category 类别(1-专题;2-事件)
     * @author lkg
     * @date 2024/4/29
     */
    List<String> belowIdList(String typeId,Integer category);

    /**
     * 新增专题分类
     *
     * @param subjectType 专题分类
     * @author lkg
     * @date 2024/4/29
     */
    void add(SubjectType subjectType);

    /**
     * 编辑专题分类
     *
     * @param subjectType 专题分类
     * @author lkg
     * @date 2024/4/29
     */
    void edit(SubjectType subjectType);

    /**
     * 删除专题分类
     *
     * @param typeId 专题分类id
     * @author lkg
     * @date 2024/4/29
     */
    void delete(String typeId);

    /**
     * 根据是否公开获取专题列表-研究中心
     *
     * @param facePublic 是否公开(1-是;0-否)
     * @author lkg
     * @date 2025/1/7
     */
    List<SubjectTreeVO> subjectsByFacePublic(Integer facePublic,String environment);

    /**
     * 专题和分类列表-研究中心
     *
     * @author lkg
     * @date 2024/12/26
     */
    List<SubjectTreeVO> subjectAndTypeTree(String environment);

    /**
     * 获取分类下的所有节点id集合-研究中心
     *
     * @param typeId 分类id
     * @param category 类别(1-专题;2-事件)
     * @author lkg
     * @date 2024/4/29
     */
    List<String> researchCenterBelowIdList(String typeId,Integer category);

    List<SubjectTypeVo> subjectListByType(String parentId);

    List<SubjectTypeVo> eventListByType(String parentId);

    /**
     * 专题/事件 分类信息树型结构，包含绑定的专题/事件数量
     *
     * @param category 类别(1-专题;2-事件)
     * @author lkg
     * @date 2025/1/8
     */
    List<SubjectTypeTreeVO> typeAndBindCountTreeList(Integer category);
    /**
     * 可用的专题和客户列表
     *
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/30
     */
    List<SubjectTreeVO> subjectAndCustomerTree(String userId,String customerId);

    /**
     * 可用的事件和事件分类列表
     *
     * @param userId     用户id
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/29
     */
    List<SubjectTreeVO> eventAndTypeTree(String userId, String customerId);
}
