package com.zzsn.event.xxljob.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Description: xxl_job_group
 * @Author: jeecg-boot
 * @Date: 2021-06-09
 * @Version: V1.0
 */
@Data
@TableName("xxl_job_group")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "xxl_job_group对象", description = "xxl_job_group")
public class XxlJobGroup implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 执行器AppName
     */
    @ApiModelProperty(value = "执行器AppName")
    private String appName;
    /**
     * 执行器名称
     */
    @ApiModelProperty(value = "执行器名称")
    private String title;
    /**
     * 执行器地址类型：0=自动注册、1=手动录入
     */
    @ApiModelProperty(value = "执行器地址类型：0=自动注册、1=手动录入")
    private Integer addressType;
    /**
     * 执行器地址列表，多地址逗号分隔
     */
    @ApiModelProperty(value = "执行器地址列表，多地址逗号分隔")
    private String addressList;
}
