package com.zzsn.event.kafka;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.entity.EventContext;
import com.zzsn.event.service.EventContextService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author lkg
 * 监听消费kafka消息
 * 消费topic中消息(注意：如果监听的topic不存在则会自动创建)
 * @date 2022/7/15
 */
@Slf4j
@Component
public class KafkaConsumer {
    @Autowired
    private EventContextService eventContextService;


    /**
     * 获取-事件脉络-分析结果数据，并入库
     *
     * @param record 接收的kafka数据
     */
    @KafkaListener(topics = {"eventContextTopic"})
    public void eventContext_new(ConsumerRecord<String, String> record) {
        String value = record.value();
        if (StringUtils.isEmpty(value)) {
            return;
        }
        List<eventContextKafkaVO> eventContextKafkaList = JSON.parseArray(value, eventContextKafkaVO.class);
        for (eventContextKafkaVO contextKafkaVO : eventContextKafkaList) {
            String uniqueCode = contextKafkaVO.getUniqueCode();
            String eventId = contextKafkaVO.getEventId();
            LambdaQueryWrapper<EventContext> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(EventContext::getEventId, eventId).eq(EventContext::getUniqueCode, uniqueCode);
            EventContext one = eventContextService.getOne(queryWrapper);
            Integer maxSortNumber = eventContextService.getMaxSortNumber(eventId);
            String keyNodeId;
            if (one == null) {
                EventContext keyNode = new EventContext();
                keyNode.setEventId(eventId);
                keyNode.setTitle(contextKafkaVO.getTitle());
                keyNode.setPublishDate(contextKafkaVO.getPublishDate());
                keyNode.setUniqueCode(uniqueCode);
                keyNode.setYnKeyNode(1);
                keyNode.setParentId("0");
                maxSortNumber = maxSortNumber + 1;
                keyNode.setSortNumber(maxSortNumber);
                eventContextService.save(keyNode);
                keyNodeId = keyNode.getId();
            } else {
                keyNodeId = one.getId();
            }
            List<EventContext> eventContextList = contextKafkaVO.getRelatedArticles();
            if (CollectionUtils.isNotEmpty(eventContextList)) {
                for (int i = 1; i <= eventContextList.size(); i++) {
                    EventContext eventContext = eventContextList.get(i);
                    eventContext.setEventId(eventId);
                    eventContext.setParentId(keyNodeId);
                    eventContext.setSortNumber(maxSortNumber + i);
                }
                eventContextService.saveBatch(eventContextList);
            }
        }
    }
}
