package com.zzsn.event.controller.common;

import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.EventLlmConfig;
import com.zzsn.event.service.EventLlmConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 大模型配置
 *
 * @author lkg
 * @date 2025/7/28
 */
@RestController
@RequestMapping("/llm/config")
public class LLmConfigController {

    @Autowired
    private EventLlmConfigService llmConfigService;

    /**
     * 事件下大模型配置信息
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2025/7/28
     */
    @GetMapping("/list")
    public Result<?> list(@RequestParam String eventId) {
        List<EventLlmConfig> configList = llmConfigService.getConfigList(eventId);
        return Result.OK(configList);
    }

    /**
     * 编辑事件的大模型配置信息
     *
     * @param eventLlmConfigList 大模型配置信息
     * @author lkg
     * @date 2025/7/28
     */
    @PostMapping("/modify")
    public Result<?> modify(@RequestBody List<EventLlmConfig> eventLlmConfigList) {
        llmConfigService.modify(eventLlmConfigList);
        return Result.OK();
    }
}
