package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.LabelEntity;
import com.zzsn.event.mapper.LabelEntityMapper;
import com.zzsn.event.service.LabelEntityService;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.util.tree.TreeUtil;
import com.zzsn.event.vo.SysLabelVo;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author lkg
 * @date 2023/3/2
 */
@Service
public class LabelEntityServiceImpl extends ServiceImpl<LabelEntityMapper, LabelEntity> implements LabelEntityService {


    @Override
    public List<LabelEntity> listByType(String labelTypeId) {
        return baseMapper.listByType(labelTypeId);
    }

    @Override
    public List<Node> regionTree(Integer type) {
        List<Node> nodes;
        if (type == 1) {
            nodes = baseMapper.regionOutList();
        } else {
            nodes = baseMapper.regionInList(null);
        }
        return TreeUtil.tree(nodes,"0");
    }

    @Override
    public List<Node> firstLevelRegions() {
        return baseMapper.regionInList(1);
    }

    @Override
    public List<SysLabelVo> queryCustomLabel(SysLabelVo sysLabelVo) {
        return baseMapper.queryCustomLabel(sysLabelVo);
    }
}
