package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.Subject;
import com.zzsn.event.vo.SubjectCondition;
import com.zzsn.event.vo.SubjectPage;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 专题表
 * @Author: jeecg-boot
 * @Date: 2021-12-01
 * @Version: V1.0
 */
@Mapper
public interface SubjectMapper extends BaseMapper<Subject> {

    /**
     * 专题分页列表
     *
     * @param subjectCondition 查询条件
     * @param offset           偏移量
     * @param pageSize         返回条数
     * @author lkg
     * @date 2024/12/18
     */
    List<SubjectPage> pageList(@Param("subjectCondition") SubjectCondition subjectCondition, @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 专题详情
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2024/12/18
     */
    SubjectPage selectSubjectById(@Param("subjectId") String subjectId);

    /**
     * 判断信息源是否在专题绑定的信息源组下
     *
     * @param subjectId 专题id
     * @param sourceId  信息源id
     * @author lkg
     * @date 2024/4/24
     */
    int ynBelowBindGroup(@Param("subjectId") String subjectId, @Param("sourceId") String sourceId);

    /**
     * 判断信息源是否在专题排除的信息源组下
     *
     * @param subjectId 专题id
     * @param sourceId  信息源id
     * @author lkg
     * @date 2024/4/24
     */
    int ynBelowExcludeGroup(@Param("subjectId") String subjectId, @Param("sourceId") String sourceId);
}
